
object Point {

  def cartesian (x:Double, y:Double):Point = 
     new Point(true,x,y)

  def polar (r:Double, theta:Double):Point = 
     new Point(false,r,theta)

}


class Point (isCart:Boolean, first:Double, second:Double) {
    // if isCart is true, then (first,second) is cartesian
    // if isCart is false, then (first,second) is polar

    def xCoord ():Double = 
       if (isCart)
         first
       else
         first * math.cos(second)
       
    def yCoord ():Double = 
       if (isCart)
         second
       else
         first * math.sin(second)

    def angleWithXAxis ():Double = 
       if (isCart)
         math.atan2(second,first)
       else
         second

    def distanceFromOrigin ():Double = 
       if (isCart)
         distance(new Point(true,0,0))
       else
         first

    def distance (q:Point):Double = 
       math.sqrt(math.pow(xCoord() - q.xCoord(),2) + 
                 math.pow(yCoord() - q.yCoord(),2))

    def move (dx:Double,dy:Double):Point = 
       new Point(true, xCoord()+dx, yCoord()+dy)

    def add (q:Point):Point = 
       move(q.xCoord(), q.yCoord())

    def rotate (theta:Double):Point = 
       if (isCart)
         new Point(true,
                   first * math.cos(theta) - second * math.sin(theta),
                   first * math.sin(theta) + second * math.cos(theta))
       else
         new Point(false, first, second+theta)

    private def normalize (angle:Double):Double = 
      if (angle >= 2*math.Pi)
        normalize(angle-2*math.Pi)
      else if (angle < 0)
        normalize(angle+2*math.Pi)
      else
        angle

    def isEqual (q:Point):Boolean = 
       if (isCart)
         first==q.xCoord() && second==q.yCoord()
       else 
         first==q.distanceFromOrigin() &&
            normalize(second)==normalize(q.angleWithXAxis())

    def isOrigin ():Boolean = 
       if (isCart) 
         first==0 && second==0
       else 
         first==0 

  override def toString ():String = 
    if (isCart)
      "cartesian(" + first + "," + second + ")"
    else
      "polar("+ first + "," + second + ")"
    
  override def equals (other : Any):Boolean = 
    other match {
      case that : Point => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 * (
        41 + isCart.hashCode()
      ) + first.hashCode()
    ) + second.hashCode()

}

