
/*
 * A view for the maze game that gives a textual report of what 
 * the player seens at the position of the player, in the
 * direction the player is facing
 *
 */

public class TextView implements View {

    private Option<Model> maze;

    protected TextView () { 
	maze = Option.none();
    }

    public static TextView create () {
	return new TextView();
    }

    public void attachToModel (Model m) {
	maze = Option.some(m);
    }

    private String status (boolean b) {
	if (b)
	    return "open";
	else
	    return "blocked";
    }

    public void update (Visible vis) {
	System.out.println("Facing: " + vis.direction());
	System.out.println("Passage in front is " + status(vis.front()));
	System.out.println("Passage on left  is " + status(vis.left()));
	System.out.println("Passage on right is " + status(vis.right()));
	if (vis.frontwin())
	    System.out.println("Winning square is up front");
    }

    public void win () {
	System.out.println("You won");
	System.exit(0);
    }

}
