
/*
 * A view for the maze game that creates a visual 1st person 
 * representation of the maze at the position of the player, in the
 * direction the player is facing
 *
 */
 

public class GUIView implements View {

    private Option<Model> maze;

    protected GUIView () { 
	maze = Option.none();
    }

    public static GUIView create () {
	GUIView v = new GUIView();
	GUI.initialize();
	return v;
    }

    public void attachToModel (Model m) {
	maze = Option.some(m);
    }
    

    public void update (Visible vis) {
	GUI.clear();

	// current square
	if (vis.left()) {
	    GUI.drawLine(0,0,0,500);
	    GUI.drawLine(0,40,40,40);
	    GUI.drawLine(0,460,40,460);
	    if (vis.front())
		GUI.drawLine(40,40,40,460);
	} else {
	    GUI.drawLine(0,0,40,40);
	    GUI.drawLine(0,500,40,460);
	}
	if (vis.right()) {
	    //	    GUI.drawLine(500,0,500,500);
	    GUI.drawLine(550,40,460,40);
	    GUI.drawLine(550,460,460,460);
	    if (vis.front())
		GUI.drawLine(460,40,460,460);
	} else {
	    GUI.drawLine(500,0,460,40);
	    GUI.drawLine(500,500,460,460);
	}

	// front square
	if (vis.front()) {
	    if (vis.frontwin()) {
		GUI.drawLine(240,100,270,80);
		GUI.drawLine(260,100,230,80);
	    }
	    if (vis.frontleft()) {
		GUI.drawLine(40,40,40,460);
		GUI.drawLine(40,140,140,140);
		GUI.drawLine(40,360,140,360);
		if (vis.frontfront())
		    GUI.drawLine(140,140,140,360);
	    } else {
		GUI.drawLine(40,40,140,140);
		GUI.drawLine(40,460,140,360);
	    }
	    if (vis.frontright()) {
		GUI.drawLine(460,40,460,460);
		GUI.drawLine(460,140,360,140);
		GUI.drawLine(460,360,360,360);
		if (vis.frontfront())
		    GUI.drawLine(360,140,360,360);
	    } else {
		GUI.drawLine(460,40,360,140);
		GUI.drawLine(460,460,360,360);
	    }

	    // front front square
	    if (vis.frontfront()) {
		if (vis.frontfrontwin()) {
		    GUI.drawLine(245,195,260,185);
		    GUI.drawLine(255,195,240,185);
		}
		if (vis.frontfrontleft()) {
		    GUI.drawLine(140,140,140,360);
		    GUI.drawLine(140,220,220,220);
		    GUI.drawLine(140,280,220,280);
		    if (vis.frontfrontfront())
			GUI.drawLine(220,220,220,280);
		} else {
		    GUI.drawLine(140,140,220,220);
		    GUI.drawLine(140,360,220,280);
		}
		if (vis.frontfrontright()) {
		    GUI.drawLine(360,140,360,360);
		    GUI.drawLine(360,220,280,220);
		    GUI.drawLine(360,280,280,280);
		    if (vis.frontfrontfront())
			GUI.drawLine(280,220,280,280);
		} else {
		    GUI.drawLine(360,140,280,220);
		    GUI.drawLine(360,360,280,280);
		}
		if (vis.frontfrontfront()) {
		    for (int i=220; i<280; i=i+3) {
			GUI.drawLine(220,i,i,220);
			GUI.drawLine(280,i,i,280);
		    }
		} else {
		    GUI.drawLine(220,220,280,220);
		    GUI.drawLine(220,280,280,280);
		    if (!vis.frontfrontleft())
			GUI.drawLine(220,220,220,280);
		    if (!vis.frontfrontright())
			GUI.drawLine(280,220,280,280);
		}
	    }
	    else {
		// no entry in front front
		GUI.drawLine(140,140,360,140);
		GUI.drawLine(140,360,360,360);
		if (!vis.frontleft())
		    GUI.drawLine(140,140,140,360);
		if (!vis.frontright())
		    GUI.drawLine(360,140,360,360);
	    }
	} else {
	    // no entry in front
	    GUI.drawLine(40,40,460,40);
	    GUI.drawLine(40,460,460,460);
	    if (!vis.left())
		GUI.drawLine(40,40,40,460);
	    if (!vis.right())
		GUI.drawLine(460,40,460,460);
	}

	GUI.redraw();
    }


    public void win () {
	System.out.println("You won");
	System.exit(0);
    }
}
