
/* 
 * A cell in the maze representation
 *
 * A cell has exits in four directions
 * each direction holding either none() if there's
 * a wall in that direction, or some(c) if the
 * direction leads to a new cell c
 *
 * These exits are held in an ArrayList from the
 * Java Collections library
 *
 */

import java.util.*;   // to get ArrayList

public class Cell {

    private ArrayList<Option<Cell>> exits;
    
    protected Cell () {
	exits = new ArrayList<Option<Cell>>(4);
	Option<Cell> n = Option.none();
	for (int i=0; i<4; i++)
	    exits.add(i,n);
    }

    public static Cell create () {
	return new Cell();
    }

    public Option<Cell> exit (Direction d) {
	return exits.get(d.ordinal());
    }


    /* attempt to connect the current cell to another cell
     * stop if the current cell already has an exit in that
     * direction 
     */
    public void connect (Direction d, Cell c) {
	if (exits.get(d.ordinal()).isNone()) {
	    exits.set(d.ordinal(),Option.some(c));
	    c.connect(d.opposite(),this);
	}
    }

    public boolean isWin () {
	return false;
    }
	
}