
import java.util.Iterator;
import java.lang.Iterable;

public abstract class List<A> implements Iterable<A> { // we can
                                                       // iterate over
                                                       // instances of
                                                       // this class

  // no java constructor for this class, it is abstract

  public static <B> List<B> empty () {
    return new EmptyList<B>();
  }

  public static <B> List<B> cons (B i, List<B> l) {
    return new ConsList<B>(i,l);
  }

  public abstract boolean isEmpty ();

  public abstract A first ();

  public abstract List<A> rest ();

  public abstract FuncIterator<A> funcIterator ();

  public Iterator<A> iterator () {
      return IteratorFromFuncIteratorAdapter.create(this.funcIterator());
  }

  public abstract void mutateFirst (A element);
      
}


/* CONCRETE CLASS FOR EMPTY CREATOR */
class EmptyList<A> extends List<A> {

 public EmptyList () {}

  public boolean isEmpty () {
    return true;
  }

  public A first () {
    throw new Error ("first() on an empty list");
  }

  public List<A> rest () {
    throw new Error ("rest() on an empty list");
  }

  public FuncIterator<A> funcIterator () {
    return new EmptyFuncIterator<A>();
  }

  public void mutateFirst (A element) {
      throw new Error ("mutateFirst() on an empty list");
  }

}


/* ITERATOR FOR EMPTY LISTS */
class EmptyFuncIterator<A> implements FuncIterator<A> {

  public EmptyFuncIterator () {}

  public boolean hasElement () {
    return false;
  }

  public A element () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncIterator.element()");
  }

  public FuncIterator<A> moveToNext () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncIterator.moveToNext()");
  }
}


/* CONCRETE CLASS FOR CONS CREATOR */
class ConsList<A> extends List<A> {

  private A firstElement;
  private List<A> restElements;

  public ConsList (A f, List<A> r) {
    firstElement = f;
    restElements = r;
  }

  public boolean isEmpty () {
    return false;
  }

  public A first () {
      return firstElement;
  }

  public List<A> rest () {
    return restElements;
  }

  public FuncIterator<A> funcIterator () {
    return new ConsFuncIterator<A>(firstElement,restElements);
  }

  public void mutateFirst (A element) {
      firstElement = element;
  }

}


/* ITERATOR FOR NON-EMPTY LISTS */
class ConsFuncIterator<A> implements FuncIterator<A> {

  private A currentElement;
  private List<A> rest;

  public ConsFuncIterator (A c, List<A> r) {
    currentElement = c;
    rest = r;
  }

  public boolean hasElement () {
    return true;
  }

  public A element () {
      return currentElement;
  }

  public FuncIterator<A> moveToNext () {
      return rest.funcIterator();
 }
}
