
import java.util.Iterator;

public class IteratorFromFuncIteratorAdapter<A> implements Iterator<A> {
    private FuncIterator<A> iter;

    private IteratorFromFuncIteratorAdapter (FuncIterator<A> it) {
        iter = it;
    }

    public static <B> IteratorFromFuncIteratorAdapter<B> create (FuncIterator<B> it) {
        return new IteratorFromFuncIteratorAdapter<B>(it);
    }

    public boolean hasNext () {
        return iter.hasElement();
    }

    public A next () {
        A elementToReturn = iter.element();
        iter = iter.moveToNext();   // this mutates an instance of this class
        return elementToReturn;
    }

    public void remove () {
	throw new UnsupportedOperationException("IteratorFromFuncIteratorAdapter.remove()");
     }

}
