
public class Main {

    public static <A> void printNth (Stream<A> s, int n) {
        Stream<A> temp = s;
        for (int i = 0; i<n; i++) {
            temp = temp.tail();
        }
        System.out.println(temp.head());
    }

    public static <A> void printStream (Stream<A> s) {
        Stream<A> temp = s;
        while (true) {
            System.out.print(temp.head() + " ");
            temp = temp.tail();
        }
    }

    public static <A> void printFirstN (Stream<A> s, int n) {

        Stream<A> temp = s;
        for (int i = 0; i < n; i++) {
            System.out.print(temp.head() + " ");
            temp = temp.tail();
        }
        System.out.println();
    }


    public static void main (String[] argv) {

        Stream<Integer> s1 = Stream.intsFrom(1);
        
        printFirstN(s1,10);
        printFirstN(Stream.sum(s1,s1),10);

        //        printStream(Stream.sum(s1,s1));

        printNth(s1,1000);
        printNth(Stream.sum(s1,s1),2000);

        Stream<Integer> s2 = Stream.filter(Even.function(),s1);

        printFirstN(s2,10);
        printNth(s2,3000);

	printFirstN(Stream.sum(s1,s2),20);


        Stream<Integer> primes = Stream.sieve(Stream.intsFrom(2));
	printFirstN(primes,20);

	printFirstN(primes,2000);
	
    }
}