
public class Main {

    private static class Double implements MappingFunction<Integer> {
        private Double () {}
        public static Double function () {
            return new Double();
        }
        public Integer apply (Integer a) {
            return 2 * a;
        }
    }

    
    private static class AddConstant implements MappingFunction<Integer> {
        private Integer constant;
        private AddConstant (Integer c) { constant = c; }
        public static AddConstant function (Integer c) { return new AddConstant(c); }
        public Integer apply (Integer val) { return val + constant; }
    }

    private static class Compose<A> implements MappingFunction<A> {
        private MappingFunction<A> f1;
        private MappingFunction<A> f2;
        private Compose (MappingFunction<A> af1,
                         MappingFunction<A> af2) {
            f1 = af1;
            f2 = af2;
        }
        public static <B> Compose<B> function (MappingFunction<B> af1,
                                        MappingFunction<B> af2) {
            return new Compose<B>(af1,af2);
        }
        public A apply (A a) {
            return f1.apply(f2.apply(a));
        }
    }


    private static class Length<A> implements ListReducingFunction<A,Integer> {
        private Length () {}
        public static <B> Length<B> function () { return new Length<B>(); }
        public Integer applyEmpty () { return 0; }
        public Integer applyCons (A val, Integer lrest) { return 1+lrest;}
    }

    private static class Sum implements ListReducingFunction<Integer,Integer> {
        private Sum () {}
        public static Sum function () { return new Sum(); }
        public Integer applyEmpty () { return 0; }
        public Integer applyCons (Integer val, Integer lrest) { return val+lrest;}
    }

    private static class Reverse<A> implements ListReducingFunction<A,List<A>> {

        private Reverse () {}

        public static <B> Reverse<B> function () { return new Reverse<B>(); }

        public List<A> applyEmpty () { return List.empty(); }

        public List<A> applyCons (A val, List<A> rrest) {
            List<A> e = List.empty();
            return rrest.append(List.cons(val,e));
        }
    }


    private static class Eval implements ExpReducingFunction<Integer> {
	private Eval () {}
	public static Eval function () { return new Eval(); }
	public Integer applyLit (int i) { return i; }
	public Integer applyPlus (Integer left, Integer right) { return left + right; }
	public Integer applyTimes (Integer left, Integer right) { return left * right; }
	public Integer applyNeg (Integer val) { return (-val); }
    }


    private static class StackCode implements ExpReducingFunction<List<String>> {
	private StackCode () {}
	public static StackCode function () { return new StackCode(); }
	public List<String> applyLit (int i) { 
	    List<String> e = List.empty();
	    return List.cons("" + i,e); 
	}
	public List<String> applyPlus (List<String> left, List<String> right) {
	    List<String> e = List.empty();
	    return left.append(right.append(List.cons("+",e)));
	}
	public List<String> applyTimes (List<String> left, List<String> right) {
	    List<String> e = List.empty();
	    return left.append(right.append(List.cons("*",e)));
	}
	public List<String> applyNeg (List<String> val) {
	    List<String> e = List.empty();
	    return val.append(List.cons("-",e));
	}
    }


    public static void main (String[] argv) {
        
        List<Integer> lst = 
            List.cons(1,List.cons(2, List.cons(3, 
		  List.cons(4, List.<Integer>empty()))));
        System.out.println("Initial list = " + lst);

        List<Integer> lst_doubled = lst.map(Double.function());
        System.out.println("Doubled list = " + lst_doubled);

        List<Integer> lst_add3 = lst.map(AddConstant.function(3));
        System.out.println("Add-3 list = " + lst_add3);

        List<Integer> lst_dbladd1 = 
            lst.map(Double.function()).map(AddConstant.function(1));
        System.out.println("Double-add-1 list = " + lst_dbladd1);

        List<Integer> lst_dbladd1alt = 
            lst.map(Compose.function(AddConstant.function(1),Double.function())); 
        System.out.println("Double-add-1 list = " + lst_dbladd1alt);

        List<Integer> lst_dbldbl = 
            lst.map(Compose.function(Double.function(),Double.function()));
        System.out.println("Double-double list = " + lst_dbldbl);

        Integer lst_length = lst.reduce(Length.<Integer>function());
        System.out.println("Length = " + lst_length);

        Integer lst_sum= lst.reduce(Sum.function());
        System.out.println("Sum = " + lst_sum);

        List<Integer> lst_rev =  lst.reduce(Reverse.<Integer>function());
        System.out.println("Reverse = " + lst_rev);

        Exp sample = Exp.times(Exp.plus(Exp.lit(5),
                                        Exp.lit(3)),
                               Exp.plus(Exp.lit(10),
                                        Exp.neg(Exp.plus(Exp.lit(22),
                                                         Exp.lit(33)))));
        System.out.println("Expression = " + sample);

        Integer eval = sample.reduce(Eval.function());
        System.out.println("Eval = " + eval);

        List<String> scode = sample.reduce(StackCode.function());
        System.out.println("Stack code = " + scode);

    }

}
