
/* ABSTRACT CLASS FOR LISTS */

public abstract class List<A> {

  // no java constructor for this class, it is abstract

  public static <A> List<A> empty () {
    return new EmptyList<A>();
  }

  public static <A> List<A> cons (A i, List<A> l) {
    return new ConsList<A>(i,l);
  }

  public abstract boolean isEmpty ();

  public abstract A first ();

  public abstract List<A> rest ();

  public abstract List<A> append (List<A> l);

  public abstract String toString ();

  public abstract List<A> map (MappingFunction<A> mf);

  public abstract <B> B reduce (ListReducingFunction<A,B> rf);

}


/* CONCRETE CLASS FOR EMPTY CREATOR */

class EmptyList<A> extends List<A> {

 public EmptyList () {}

  public boolean isEmpty () {
    return true;
  }

  public A first () {
    throw new Error ("first() on an empty list");
  }

  public List<A> rest () {
    throw new Error ("rest() on an empty list");
  }

  public List<A> append (List<A> l) {
      return l;
  }

  public String toString () {
      return "";
  }

  public List<A> map (MappingFunction<A> mf) {
      return List.empty();
  }

  public <B> B reduce (ListReducingFunction<A,B> rf) {
      return rf.applyEmpty();
  }



}



/* CONCRETE CLASS FOR CONS CREATOR */

class ConsList<A> extends List<A> {

  private A first;
  private List<A> rest;

  public ConsList (A f, List<A> r) {
    first = f;
    rest = r;
  }

  public boolean isEmpty () {
    return false;
  }

  public A first () {
    return first;
  }

  public List<A> rest () {
    return rest;
  }

  public List<A> append (List<A> l) {
      return List.cons(first,rest.append(l));
  }

  public String toString () {
      return first.toString() + "  " + rest.toString();
  }

  public List<A> map (MappingFunction<A> mf) {
      return List.cons(mf.apply(first), rest.map(mf));
  }

  public <B> B reduce (ListReducingFunction<A,B> rf) {
      return rf.applyCons(first, rest.reduce(rf));
  }


}

