
public abstract class Exp {

    public static Exp lit (int i) {
	return new ExpLit(i);
    }

    public static Exp plus (Exp e1, Exp e2) {
	return new ExpPlus(e1,e2);
    }

    public static Exp times (Exp e1, Exp e2) {
	return new ExpTimes(e1,e2);
    }

    public static Exp neg (Exp e) {
	return new ExpNeg(e);
    }

    public abstract <B> B reduce (ExpReducingFunction<B> rf);
    
    public abstract String toString ();
}


class ExpLit extends Exp {

    private int value;
    public ExpLit (int v) {
	value = v;
    }

    public <B> B reduce (ExpReducingFunction<B> rf) {
	return rf.applyLit(value);
    }

    public String toString () {
	return "" + value;
    }
}


class ExpPlus extends Exp {
    private Exp left;
    private Exp right;
    public ExpPlus (Exp l, Exp r) {
	left = l;
	right = r;
    }

    public <B> B reduce (ExpReducingFunction<B> rf) {
	B lred = left.reduce(rf);
	B rred = right.reduce(rf);
	return rf.applyPlus(lred,rred);
    }

    public String toString () {
	return "("+left.toString()+" + "+right.toString()+")";
    }
}

class ExpTimes extends Exp {
    private Exp left;
    private Exp right;
    public ExpTimes (Exp l, Exp r) {
	left = l;
	right = r;
    }

    public <B> B reduce (ExpReducingFunction<B> rf) {
	B lred = left.reduce(rf);
	B rred = right.reduce(rf);
	return rf.applyTimes(lred,rred);
    }

    public String toString () {
	return "("+left.toString()+" * "+right.toString()+")";
    }
}



class ExpNeg extends Exp {

    private Exp value;
    public ExpNeg (Exp v) {
	value = v;
    }

    public <B> B reduce (ExpReducingFunction<B> rf) {
	B vred = value.reduce(rf);
	return rf.applyNeg(vred);
    }

    public String toString () {
	return (" -"+value.toString());
    }
}
