
public class ZipGadget<A,B> implements FuncIterator<Pair<A,B>> {

    private FuncIterator<A> connectedTo1;
    private FuncIterator<B> connectedTo2;

    private ZipGadget (FuncIterator<A> c1, FuncIterator<B> c2) {
        connectedTo1 = c1;
        connectedTo2 = c2;
    }

    public static <C,D> ZipGadget<C,D> create (FuncIterator<C> c1, 
					       FuncIterator<D> c2) {
        return new ZipGadget<C,D>(c1,c2);
    }

    public boolean hasElement () {
        return (connectedTo1.hasElement() && connectedTo2.hasElement());
    }

    public Pair<A,B> element () {
        return Pair.create(connectedTo1.element(), connectedTo2.element());
    }

    public FuncIterator<Pair<A,B>> moveToNext () {
        return ZipGadget.create(connectedTo1.moveToNext(),
                               connectedTo2.moveToNext());
    }
}
