
public class SkipGadget<A> implements FuncIterator<A>   {

    private FuncIterator<A> connectedTo;
    
    private SkipGadget (FuncIterator<A> it) {
        connectedTo = it;
    }

    public static <B> SkipGadget<B> create (FuncIterator<B> it) {
        return new SkipGadget<B>(it);
    }

    public boolean hasElement () {
        return connectedTo.hasElement();
    }

    public A element () {
        return connectedTo.element();
    }

    public FuncIterator<A> moveToNext () {
        FuncIterator<A> next = connectedTo.moveToNext();
        if (next.hasElement()) {
            FuncIterator<A> nnext = next.moveToNext();
            return SkipGadget.create(nnext);
        }
        return SkipGadget.create(next);
    }

}
