
public class SequenceGadget<A> implements FuncIterator<A> {

    private FuncIterator<A> connectedTo1;
    private FuncIterator<A> connectedTo2;

    private SequenceGadget (FuncIterator<A> c1, FuncIterator<A> c2) {
        connectedTo1 = c1;
        connectedTo2 = c2;
    }

    public static <B> SequenceGadget<B> create (FuncIterator<B> c1, 
						FuncIterator<B> c2) {
        return new SequenceGadget<B>(c1,c2);
    }

    public boolean hasElement () {
        return (connectedTo1.hasElement() || connectedTo2.hasElement());
    }

    public A element () {
        if (connectedTo1.hasElement())
            return connectedTo1.element();
        return connectedTo2.element();
    }

    public FuncIterator<A> moveToNext () {
        if (connectedTo1.hasElement())
            return SequenceGadget.create(connectedTo1.moveToNext(),
                                        connectedTo2);
        return SequenceGadget.create(connectedTo1,connectedTo2.moveToNext());
        // alternatively: return connectedTo2.moveToNext();
    }
}
