
public abstract class ReverseGadget<A> implements FuncIterator<A>   {

    private static <B> ReverseGadget<B> helper (ReverseGadget<B> r,
						FuncIterator<B> it) {
	if (it.hasElement()) {
	    ReverseGadget<B> newRev = 
		new ReverseGadget.NonEmpty<B>(it.element(),r);
	    return helper(newRev,it.moveToNext());
	} else {
	    return r;
	}
    }

    public static <B> ReverseGadget<B> create (FuncIterator<B> it) {
        return helper(new ReverseGadget.Empty<B>(), it);
    }

    public abstract boolean hasElement ();
    public abstract A element ();
    public abstract FuncIterator<A> moveToNext ();


    private static class Empty<B> extends ReverseGadget<B> {
	public Empty () {}

	public boolean hasElement () {
	    return false;
	}

	public B element () {
	    throw new java.util.NoSuchElementException
		("ReverseGadget.Empty.element()");
	}
	
	public FuncIterator<B> moveToNext () {
	    throw new java.util.NoSuchElementException
		("ReverseGadget.Empty.moveToNext()");
	}	    
	
    }

    private static class NonEmpty<B> extends ReverseGadget<B> {
	private B element;
	private FuncIterator<B> rest;
	
	public NonEmpty (B elt, FuncIterator<B> r) {
	    element = elt;
	    rest = r;
	}

	public boolean hasElement () {
	    return true;
	}

	public B element () {
	    return element;
	}
	
	public FuncIterator<B> moveToNext () {
	    return rest;
	}	    
	
    }


}
