
public class Main {

    public static <B> void show (String s, FuncIterator<B> it) {
        FuncIterator<B> temp = it;
        
	System.out.print(s + " =");
        while (temp.hasElement()) {
            System.out.print ("  " + temp.element());
            temp = temp.moveToNext();
        }
	System.out.println("");
    }	
    
    public static void main (String[] argv) {
	
	List<Integer> nothing = List.empty();
	List<Integer> a = List.cons(1, List.cons(2, List.cons(3, nothing)));
	
	List<Integer> b = List.cons(66, 
				    List.cons(99, 
					      List.cons(89, 
							List.cons(11, 
								  nothing))));
	
	show("a", 
	     a.funcIterator());

	show("b",
	     b.funcIterator());

	show("Double(a)",
	     DoubleGadget.create(a.funcIterator()));

	show("Double(b)",
	     DoubleGadget.create(b.funcIterator()));

	show("Skip(a)",
	     SkipGadget.create(a.funcIterator()));

	show("Skip(b)",
	     SkipGadget.create(b.funcIterator()));

	show("Skip(Double(a))",
	     SkipGadget.create(DoubleGadget.create(a.funcIterator())));
	
	show("a & b",
	     SequenceGadget.create(a.funcIterator(),
				   b.funcIterator()));
	
	show("Skip(a) & Double(b)",
	     SequenceGadget.create(SkipGadget.create(a.funcIterator()),
				   DoubleGadget.create(b.funcIterator())));

	show("a & a",
	     SequenceGadget.create(a.funcIterator(),a.funcIterator()));
	
	show("Zip(a,b)",
	     ZipGadget.create(a.funcIterator(),b.funcIterator()));

	show("Zip(a,Skip(b))",
	     ZipGadget.create(a.funcIterator(),
			      SkipGadget.create(b.funcIterator())));

	show("Cartesian(a,b)",
	     CartesianGadget.create(a.funcIterator(),
				    b.funcIterator()));
    
	show("Cartesian(a,Zip(b,Double(b)))",
	     CartesianGadget.create(a.funcIterator(),
				    ZipGadget.create(b.funcIterator(),
						     DoubleGadget.create(b.funcIterator()))));

	show("Reverse(a)",
	     ReverseGadget.create(a.funcIterator()));

	show("Cartesian(a,a)",
	     CartesianGadget.create(a.funcIterator(),a.funcIterator()));

	show("Reverse(Cartesian(a,a))",
	     ReverseGadget.create(CartesianGadget.create(a.funcIterator(),
							 a.funcIterator())));
	     
  }

}
