
public class DoubleGadget implements FuncIterator<Integer> {

    private FuncIterator<Integer> connectedTo;

    private DoubleGadget (FuncIterator<Integer> it) {
        connectedTo = it;
    }
    
    public static DoubleGadget create (FuncIterator<Integer> it) {
        return new DoubleGadget(it);
    }

    public boolean hasElement () {
        return connectedTo.hasElement();
    }

    public Integer element () {
        return 2*connectedTo.element();
    }

    public FuncIterator<Integer> moveToNext () {
        return DoubleGadget.create(connectedTo.moveToNext());
    }

}
