
public class CartesianGadget<A,B> implements FuncIterator<Pair<A,B>> {

    private FuncIterator<A> connectedTo1;
    private FuncIterator<B> connectedTo2;
    private FuncIterator<B> initConnectedTo2;

    private CartesianGadget (FuncIterator<A> c1, FuncIterator<B> c2,
			     FuncIterator<B> initC2) {
        connectedTo1 = c1;
        connectedTo2 = c2;
	initConnectedTo2 = initC2;
    }

    public static <C,D> CartesianGadget<C,D> create (FuncIterator<C> c1, 
						     FuncIterator<D> c2) {
        return new CartesianGadget<C,D>(c1,c2,c2);
    }

    public boolean hasElement () {
        return connectedTo1.hasElement();
    }

    public Pair<A,B> element () {
        return Pair.create(connectedTo1.element(), connectedTo2.element());
    }

    public FuncIterator<Pair<A,B>> moveToNext () {
	FuncIterator<B> nextC2 = connectedTo2.moveToNext();
	if (nextC2.hasElement())
	    return new CartesianGadget<A,B>(connectedTo1,nextC2,
					    initConnectedTo2);
	return new CartesianGadget<A,B>(connectedTo1.moveToNext(),
					initConnectedTo2,
					initConnectedTo2);
    }
}
