
public class Pair<T,U> {

    private T first;
    private U second;

    protected Pair () {}

    private Pair (T f, U s) {
        first = f;
        second = s;
    }

    public static <V,W> Pair<V,W> create (V f, W s) {
        return new Pair<V,W>(f,s);
    }

    public T first () {
        return first;
    }

    public U second () {
        return second;
    }

    public String toString () {
        return "(" + first().toString() + "," + second().toString() + ")";
    }

}