
public class AddablePair<T extends Addable<T>, U extends Addable<U>>
    extends Pair<T,U> implements Addable<AddablePair<T,U>>  {

    private T first;
    private U second;

    private AddablePair (T f, U s) {
        first = f;
        second = s;
    }

    public static <V extends Addable<V>, W extends Addable<W>> 
                                  AddablePair<V,W> create (V f, W s) {
        return new AddablePair<V,W>(f,s);
    }

    public T first () {
        return first;
    }

    public U second () {
        return second;
    }

    public AddablePair<T,U> add (AddablePair<T,U> p) {
        return create(first().add(p.first()),second().add(p.second()));
    }

    public String toString () {
        return "(" + first().toString() + "," + second().toString() + ")";
    }

}