/* ABSTRACT CLASS FOR LISTS */
public abstract class ListPair {

  // no java constructor for this class, it is abstract

  public static ListPair empty () {
    return new EmptyListPair();
  }

  public static ListPair cons (PairAI i, ListPair l) {
    return new ConsListPair(i,l);
  }

  public abstract boolean isEmpty ();

  public abstract PairAI first ();

  public abstract ListPair rest ();

  public abstract FuncIterator<PairAI> funcIterator ();
}


/* CONCRETE CLASS FOR EMPTY CREATOR */
class EmptyListPair extends ListPair {

 public EmptyListPair () {}

  public boolean isEmpty () {
    return true;
  }

  public PairAI first () {
    throw new Error ("first() on an empty list");
  }

  public ListPair rest () {
    throw new Error ("rest() on an empty list");
  }

  public FuncIterator<PairAI> funcIterator () {
    return new EmptyFuncPairIterator();
  }
}


/* ITERATOR FOR EMPTY LISTS */
class EmptyFuncPairIterator implements FuncIterator<PairAI> {

  public EmptyFuncPairIterator () {}

  public boolean hasElement () {
    return false;
  }

  public PairAI element () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncPairIterator.element()");
  }

  public FuncIterator<PairAI> moveToNext () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncPairIterator.moveToNext()");
  }
}


/* CONCRETE CLASS FOR CONS CREATOR */
class ConsListPair extends ListPair {

  private PairAI firstElement;
  private ListPair restElements;

  public ConsListPair (PairAI f, ListPair r) {
    firstElement = f;
    restElements = r;
  }

  public boolean isEmpty () {
    return false;
  }

  public PairAI first () {
      return firstElement;
  }

  public ListPair rest () {
    return restElements;
  }

  public FuncIterator<PairAI> funcIterator () {
    return new ConsFuncPairIterator(firstElement,restElements);
  }
}


/* ITERATOR FOR NON-EMPTY LISTS */
class ConsFuncPairIterator implements FuncIterator<PairAI> {

  private PairAI currentElement;
  private ListPair rest;

  public ConsFuncPairIterator (PairAI c, ListPair r) {
    currentElement = c;
    rest = r;
  }

  public boolean hasElement () {
    return true;
  }

  public PairAI element () {
      return currentElement;
  }

  public FuncIterator<PairAI> moveToNext () {
      return rest.funcIterator();
 }
}
