/* ABSTRACT CLASS FOR LISTS */
public abstract class List {

  // no java constructor for this class, it is abstract

  public static List empty () {
    return new EmptyList();
  }

  public static List cons (int i, List l) {
    return new ConsList(i,l);
  }

  public abstract boolean isEmpty ();

  public abstract int first ();

  public abstract List rest ();

  public abstract FuncIterator<AInteger> funcIterator ();
}


/* CONCRETE CLASS FOR EMPTY CREATOR */
class EmptyList extends List {

 public EmptyList () {}

  public boolean isEmpty () {
    return true;
  }

  public int first () {
    throw new Error ("first() on an empty list");
  }

  public List rest () {
    throw new Error ("rest() on an empty list");
  }

  public FuncIterator<AInteger> funcIterator () {
    return new EmptyFuncIterator();
  }
}


/* ITERATOR FOR EMPTY LISTS */
class EmptyFuncIterator implements FuncIterator<AInteger> {

  public EmptyFuncIterator () {}

  public boolean hasElement () {
    return false;
  }

  public AInteger element () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncIterator.element()");
  }

  public FuncIterator<AInteger> moveToNext () {
   throw new java.util.NoSuchElementException
       ("EmptyFuncIterator.moveToNext()");
  }
}


/* CONCRETE CLASS FOR CONS CREATOR */
class ConsList extends List {

  private int firstElement;
  private List restElements;

  public ConsList (int f, List r) {
    firstElement = f;
    restElements = r;
  }

  public boolean isEmpty () {
    return false;
  }

  public int first () {
      return firstElement;
  }

  public List rest () {
    return restElements;
  }

  public FuncIterator<AInteger> funcIterator () {
    return new ConsFuncIterator(firstElement,restElements);
  }
}


/* ITERATOR FOR NON-EMPTY LISTS */
class ConsFuncIterator implements FuncIterator<AInteger> {

  private int currentElement;
  private List rest;

  public ConsFuncIterator (int c, List r) {
    currentElement = c;
    rest = r;
  }

  public boolean hasElement () {
    return true;
  }

  public AInteger element () {
      return AInteger.create(currentElement);
  }

  public FuncIterator<AInteger> moveToNext () {
      return rest.funcIterator();
 }
}
