
// An implementation of the List ADT using the
// Specification Design Pattern


public abstract class List {   // abstract == cannot instantiate this class

    public static List empty () {
        return new EmptyList();
    }

    public static List cons (int i, List L) {
        return new ConsList(i,L);
    }

    public abstract boolean isEmpty ();
    public abstract int first ();
    public abstract List rest ();
    public abstract String toString ();

    public abstract FuncIteratorInt funcIterator ();
    
}



class EmptyList extends List {
    public EmptyList () {    // the ONE place where we have public constructor
    }
    public boolean isEmpty () {
        return true;
    }
    public int first () { 
        throw new RuntimeException("empty().first()");
    }
    public List rest () { 
        throw new RuntimeException("empty().rest()");
    }
    public String toString () { 
        return "";
    }

    public FuncIteratorInt funcIterator () {
        return new EmptyFuncIteratorInt();
    }
    
}




class EmptyFuncIteratorInt implements FuncIteratorInt {

    public EmptyFuncIteratorInt () {}

    public boolean hasElement () {
        return false;
    }

    public int element () {
        throw new java.util.NoSuchElementException("EmptyFuncIteratorInt.element()");
    }

    public FuncIteratorInt moveToNext () {
        throw new java.util.NoSuchElementException("EmptyFuncIteratorInt.moveToNext()");
    }

}





class ConsList extends List {
    private int f;
    private List r;
    public ConsList (int i, List l) {
        f = i;
        r = l;
    }
    public boolean isEmpty () {
        return false;
    }
    public int first () { 
        return f;
    }
    public List rest () { 
        return r;
    }
    public String toString () { 
        return f + " " + r.toString();
    }

    public FuncIteratorInt funcIterator () {
        return new ConsFuncIteratorInt(f,r);
    }
}



class ConsFuncIteratorInt implements FuncIteratorInt {
    
    private int f;
    private List r;

    public ConsFuncIteratorInt (int farg, List rarg) {
        f = farg;
        r = rarg;
    }

    public boolean hasElement () {
        return true;
    }

    public int element () {
        return f;
    }

    public FuncIteratorInt moveToNext () {
        return r.funcIterator();
    }
    

}