
public class Drawing {

    private boolean isempty;
    private Line first;
    private Drawing rest;
    
    private Drawing (boolean i, Line f, Drawing r) {
        this.isempty = i;
        this.first = f;
        this.rest = r;
    }

    
    public static Drawing empty () {
        return new Drawing(true, null, null);
    }

    public static Drawing oneLine (Line l) {
        return new Drawing(false, l, Drawing.empty());
    }

    public static Drawing merge(Drawing d1, Drawing d2) {
        if (d1.isEmpty())
            return d2;
        else
            return new Drawing(false, 
                               d1.firstLine(),
                               Drawing.merge(d1.restDrawing(),d2));
    }

    
    public boolean isEmpty () {
        return (this.isempty);
    }

    public Line firstLine () {
        if (this.isEmpty())
            throw new Error ("Drawing.firstLine(): empty");
        else
            return this.first;
    }

    public Drawing restDrawing () {
        if (this.isEmpty())
            throw new Error ("Drawing.restDrawing(): empty");
        else
            return this.rest;
    }
    

}


// nonstatic method (dynamic method, method):
//     d.isEmpty()
//
// static method:
//     Drawing.empty()


