
public class Main {

    //Display a message, preceded by the name of the current thread

    static void threadMessage (String msg) {
        String threadName = Thread.currentThread().getName();
        System.out.println("[" + threadName + ": " + msg + "]");
    }


    public static void main (String[] argv) throws InterruptedException {

	Channel<Triple<Integer,Integer,Channel<Integer>>> valuesCh = 
	    Channel.create();

	Thread addClient1, addClient2, addServer;
	addClient1 = new Thread(AddClient.create(50,valuesCh),
				"client1");
	addClient1.start();

	addClient2 = new Thread(AddClient.create(10,valuesCh),
				"client2");
	addClient2.start();
	
	addServer = new Thread(AddServer.create(valuesCh),"server");
	addServer.start();


	Thread.sleep(60000);
	addClient1.interrupt();
	addClient2.interrupt();
	addServer.interrupt();
	addClient1.join();
	addClient2.join();
	addServer.join();
    }

}