
import java.util.*;
import java.io.*;

public class AddClient implements Runnable {

    private Channel<Triple<Integer,Integer,Channel<Integer>>> valuesCh;

    private int delay;

    private AddClient (int s, 
		       Channel<Triple<Integer,Integer,Channel<Integer>>> c) {
	delay = s;
	valuesCh = c;
    }


    public static AddClient create 
               (int s, Channel<Triple<Integer,Integer,Channel<Integer>>> c) {
	return new AddClient(s,c);
    }


    private static Random rnd = new Random();

    public static int random(int bound) {
	return rnd.nextInt(bound);
    }


    public void run () {

	try {

	    Main.threadMessage("start");

	    while (true) {
		int i1 = random(100);
		int i2 = random(100);

		Channel<Integer> resultCh = Channel.create();

		Main.threadMessage("asking for " + i1 + " + " + i2);
		valuesCh.putOrBlock(Triple.create(i1,i2,resultCh));

		Thread.sleep(delay);

		Integer response = resultCh.getOrBlock();
		Main.threadMessage("Received response = " + response);
		System.out.print(i1+" + "+i2+" = " + response);
		if (i1+i2 == response.intValue())
		    System.out.println("");
		else 
		    System.out.println("                     ====>  WRONG!");

	    }
	    //	    Main.threadMessage("finished");
	} catch (InterruptedException e) {
	    Main.threadMessage("interrupted");
	    return;
	}
    }
}
