
public class Channel<E> {

    private Option<E> content;

    private Channel () { 
	content = Option.none();
    }

    public static <T> Channel<T> create () {
	return new Channel<T>();
    }


    // Put a value on the channel if none is present 
    //
    public boolean put (E val) {
	    if (content.isNone()) {
		content = Option.some(val);
		return true;
	    }
	    return false;
	}

    // Put a value on the channel, block until the put can be done
    //
    public void putOrBlock (E val) throws InterruptedException {
	while (!put(val)) {
	    Thread.sleep(100);
	}
    }


    // Get a value (possibly none) from the channel
    //
    public Option<E> get () {
	    if (content.isNone())
		return content;
	    Option<E> result = content;
	    content = Option.none();
	    return result;
	}


    // Block until there is a value on the channel, then get it
    //
    public E getOrBlock () throws InterruptedException {
	Option<E> response;
	response = get();
	while (response.isNone()) {
	    Thread.sleep(100);
	    response = get();
	} 
	return response.valOf();
    }

}