
import java.io.*;

public class AddServer implements Runnable {

    private Channel<Pair<Integer,Integer>> valuesCh;
    private Channel<Integer> resultCh;

    private AddServer (Channel<Pair<Integer,Integer>> c1,
		       Channel<Integer> c2) {
	valuesCh = c1;
	resultCh = c2;
    }


    public static AddServer create (Channel<Pair<Integer,Integer>> c1,
				    Channel<Integer> c2) {
	return new AddServer(c1,c2);
    }



    public void run () {

	try {
	    Main.threadMessage("started");

	    while (true) {

		Pair<Integer,Integer> input = valuesCh.getOrBlock();
		
		int i1 = input.first();
		int i2 = input.second();
		Main.threadMessage("computing "+i1+" + "+i2+" = "+(i1+i2));
		
		resultCh.putOrBlock(i1+i2);
	    }
	    // Main.threadMessage("finished");
	} catch (InterruptedException e) {
	    Main.threadMessage("interrupted");
	    return;
	}
    }
}