
import java.util.*;
import java.io.*;

public class AddClient implements Runnable {

    private Channel<Pair<Integer,Integer>> valuesCh;
    private Channel<Integer> resultCh;

    private int delay;

    private AddClient (int s, Channel<Pair<Integer,Integer>> c1,
		       Channel<Integer> c2) {
	delay = s;
	valuesCh = c1;
	resultCh = c2;
    }


    public static AddClient create (int s, Channel<Pair<Integer,Integer>> c1,
				    Channel<Integer> c2) {
	return new AddClient(s,c1,c2);
    }

    private static Random rnd = new Random();

    public static int random(int bound) {
	return rnd.nextInt(bound);
    }

    public void run () {
	
	try {
	    
	    Main.threadMessage("start");
	    
	    while (true) {
		int i1 = random(100);
		int i2 = random(100);

		Main.threadMessage("asking for " + i1 + " + " + i2);
		valuesCh.putOrBlock(Pair.create(i1,i2));

		Thread.sleep(delay);

		Integer response = resultCh.getOrBlock();

		Main.threadMessage("Received response = " + response);
		System.out.print(i1 + " + " + i2 + " = " + response);
		if (i1+i2 == response.intValue())
		    System.out.println("");
		else
		    System.out.println("                      ===>  WRONG!");
		    
	    }
	    //	    Main.threadMessage("finished");
	} catch (InterruptedException e) {
	    Main.threadMessage("interrupted");
	    return;
	}
    }
}
