
public class Main {

    //Display a message, preceded by the name of the current thread

    static void threadMessage (String msg) {
        String threadName = Thread.currentThread().getName();
        System.out.println("[" + threadName + ": " + msg + "]");
    }


    public static void main (String[] argv) throws InterruptedException {

	Channel<Pair<Integer,Integer>> valuesCh = Channel.create();
	Channel<Integer> resultCh = Channel.create();

	Thread addClientT, addServerT;
	threadMessage("starting add client thread");
	addClientT = new Thread(AddClient.create(valuesCh,resultCh),"client");
	addClientT.start();
	
	threadMessage("starting server thread");
	addServerT = new Thread(AddServer.create(valuesCh,resultCh),"server");
	addServerT.start();

	threadMessage("waiting for client thread to finish");

	addClientT.join();
	threadMessage("terminating server thread");

	addServerT.interrupt();
	addServerT.join();
    }

}