
import java.io.*;

public class AddClient implements Runnable {

    private Channel<Pair<Integer,Integer>> valuesCh;
    private Channel<Integer> resultCh;

    private AddClient (Channel<Pair<Integer,Integer>> c1,
		       Channel<Integer> c2) {
	valuesCh = c1;
	resultCh = c2;
    }


    public static AddClient create (Channel<Pair<Integer,Integer>> c1,
				    Channel<Integer> c2) {
	return new AddClient(c1,c2);
    }


    private static int stringToInt (String s) {
	try {
	    return Integer.parseInt(s);
	} catch (NumberFormatException nfe) {
	    return 0;
	}
    }



    private static Option<String> getInput () {

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = "";
    
        try {
            response = br.readLine();
            if (response==null) {
                return Option.none();
            }
        } catch (IOException ioe) {
	    System.err.println("IO error reading from terminal");
	    System.exit(-1);
	}
        return Option.some(response);
    }



    public void run () {

	try {
	    Main.threadMessage("started");

	    while (true) {

		System.out.print("First number: ");
		Option<String> input1 = getInput();
		if (input1.isNone())
		    break;
		int i1 = stringToInt(input1.valOf());

		System.out.print("Second number: ");
		Option<String> input2 = getInput();
		if (input2.isNone())
		    break;
		int i2 = stringToInt(input2.valOf());

		valuesCh.putOrBlock(Pair.create(i1,i2));
		Main.threadMessage("awaiting response from server");
		Integer response = resultCh.getOrBlock();
		System.out.println("result= " + response);
	    }
	    Main.threadMessage("finished");
	} catch (InterruptedException e) {
	    Main.threadMessage("interrupted");
	    return;
	}
    }
}
