import java.io.*;
import java.net.*;

/* A simplified way to do socket programming
 * Really, it just fails with errors instead of gracefully,
 * and it automates the created of input/output streams for 
 * sending and receiving 
 *
 * Any nontrivial use of sockets should use the actual socket library
 */


/* 
 *    This defines "server" sockets for listening
 */

public class ServSocket {

    private ServerSocket socket;

    private static void error (String s) {
	System.err.println(s);
	System.exit(-1);
    }
    
    private ServSocket (ServerSocket s) {
	socket = s;
    }

    private ServSocket(int port) {
	try {
	    socket = new ServerSocket(port);
	} catch (UnknownHostException e) {
	    error("Unknown address");
	} catch (IOException e) {
	    error("Error connecting to server");
	}
    }

    //    Create server socket from a port number
    //
    public static ServSocket create (int port) {
	ServerSocket s = null;
	try {
	    s = new ServerSocket(port);
	} catch (UnknownHostException e) {
	    error("Unknown address");
	} catch (IOException e) {
	    error("Cannot create server socket");
	}
	return new ServSocket(s);
    }

    //    Create server socket from a bonafide server socket
    //
    public static ServSocket create (ServerSocket s) {
	return new ServSocket(s);
    }


    public ServerSocket socket () {
	return socket;
    }

    public ChanSocket accept () {
	Socket cs = null;
        try {
            cs = socket.accept();
        } catch (IOException e) {
	    error("Cannot accept connection");
	}
	return ChanSocket.create(cs);
    }


    public void close () {
	try {
	    socket.close();
	} catch (IOException e) {}
    }

}