import java.io.*;
import java.net.*;

/* A simplified way to do socket programming
 * Really, it just fails with errors instead of gracefully,
 * and it automates the created of input/output streams for 
 * sending and receiving 
 *
 * Any nontrivial use of sockets should use the actual socket library
 */


/* 
 *    This defines "channel" sockets for communicating
 */

public class ChanSocket {

    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;

    private static BufferedReader socketReader (Socket s) throws IOException {
	InputStreamReader isr = new InputStreamReader(s.getInputStream());
	return new BufferedReader(isr);
    }

    private static PrintWriter socketWriter (Socket s) throws IOException {
	return new PrintWriter(s.getOutputStream(), true);	
    }

    private static void error (String s) {
	System.err.println(s);
	System.exit(-1);
    }

    private ChanSocket(Socket s) {
	try {
	    socket = s;
	    in = socketReader(socket);
	    out = socketWriter(socket);
	} catch (IOException e) {
	    error("Error connecting socket");
	}
    }


    //    Create a channel socket using an address and a port
    //
    public static ChanSocket create (String addr, int port) {
	Socket s = null;
	try {
	    s = new Socket(addr,port);
	} catch (UnknownHostException e) {
	    error("Unknown address");
	} catch (IOException e) {
	    error("Cannot create socket");
	}
	return new ChanSocket(s);
    }

    //    Create a channel socket using a bonafide socket
    //
    public static ChanSocket create (Socket s) {
	return new ChanSocket(s);
    }


    public Socket socket () {
	return socket;
    }

    public BufferedReader in () {
	return in;
    }

    public PrintWriter out () {
	return out;
    }

    public void close () {
	try {
	    out.close();
	    in.close();
	    socket.close();
	} catch (IOException e) {}
    }

}