import java.net.*;
import java.io.*;

public class AddServer {

    private static void error (String s) {
	System.err.println(s);
	System.exit(-1);
    }

    private static int stringToInt (String s) {
	try {
	    return Integer.parseInt(s);
	} catch (NumberFormatException nfe) {
	    return 0;
	}
    }


    public static void main (String[] argv) throws IOException {

        ServSocket serverSocket = ServSocket.create(8044);

	System.out.println("Listening on port 8044");

        ChanSocket clientSocket = serverSocket.accept();

	System.out.println("Accepting connection");

	while (true) {
	    String input1 = clientSocket.in().readLine();
	    String input2 = clientSocket.in().readLine();
	    if (input1==null || input2==null) 
		break;
	    int i1 = stringToInt(input1);
	    int i2 = stringToInt(input2);
	    System.out.println("Computing sum of " + i1 + " and " + i2);
	    clientSocket.out().println(i1+i2);
	}

        clientSocket.close();
        serverSocket.close();
    }
}
