
import java.io.*;
import java.net.*;

public class AddClient {

    private static void error (String s) {
	System.err.println(s);
	System.exit(-1);
    }



    private static Option<String> getInput () {

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = "";
    
        try {
            response = br.readLine();
            if (response==null) {
                return Option.none();
            }
        } catch (IOException ioe) {
	    error("IO error reading from terminal");
	}
        return Option.some(response);
    }



    public static void main (String[] argv) throws IOException {

        ChanSocket addSocket = null;

	addSocket = ChanSocket.create("127.0.0.1",8044);

	System.out.println("Connected to server");

	Option<String> input1, input2;
	String response;

	while (true) {
	    System.out.print("First number: ");
	    input1 = getInput();
	    if (input1.isNone())
		break;
	    addSocket.out().println(input1.valOf());
	    System.out.print("Second number: ");
	    input2 = getInput();
	    if (input2.isNone())
		break;
	    addSocket.out().println(input2.valOf());
	    response = addSocket.in().readLine();
	    System.out.println("result= " + response);
	}

	addSocket.close();
    }
}
