
/*
 * A controller for the maze game that uses a command line to get
 * commands and direct those commands to the model
 *
 * Commands:
 *  forward (or f)
 *  back    (or b)
 *  left    (or l)
 *  right   (or r)
 *  quit    (or q)
 *
 */

import java.io.*;

public class TextController implements Controller {

    private Option<Model> maze;

    protected TextController () { 
	maze = Option.none();
    }

    public static TextController create () {
	return new TextController();
    }

    public void attachToModel (Model m) {
	maze = Option.some(m);
    }

    private String getInput () {

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = "";
    
        try {
            response = br.readLine();
            if (response==null) {
                return "";
            }
        } catch (IOException ioe) {
            System.out.println("IO error reading from terminal\n");
            System.exit(1);
        }
        return response;
    }

    private boolean process (String response) {
	if (response.equals("forward") || response.equals("f"))
	    return maze.valOf().performForward();
	else if (response.equals("back") || response.equals("b"))
	    return maze.valOf().performBack();
	else if (response.equals("left") || response.equals("l"))
	    return maze.valOf().performLeft();
	else if (response.equals("right") || response.equals("r"))
	    return maze.valOf().performRight();
	else if (response.equals("quit") || response.equals("q"))
	    System.exit(0);
	return false;
    }



    public void run () { 
        String response;

	if (maze.isNone())
	    throw new Error("TextController not initialized with model");

        while (true) {
            System.out.print("> ");
            response = getInput();
	    if (!process(response))
		System.out.println("Cannot perform action");
	}
	
    }

}
	
