
/*
 * A controller for the maze game that uses key presses in the GUI window 
 * to determine which actions to send to the model
 *
 * This is clunky because getting key presses from the window is clunky,
 * at least given the way I've set things up
 *
 * Roughly, this defines an observer for key presses that gets
 * registered in the GUI so that we get notified whenever there is 
 * a key pressed
 *
 * CONTROLS:
 *  i  - forward
 *  k  - back
 *  j  - left
 *  l  - right
 *  q  - quit
 *
 */

import java.io.*;

public class GUIController implements Controller {

    private Option<Model> maze;

    protected GUIController () { 
	maze = Option.none();
    }

    public static GUIController create () {
	GUI.initialize();
	return new GUIController();
    }

    public void attachToModel (Model m) {
	maze = Option.some(m);
    }

    public static class KeyObserver implements Observer<Character> {
	private Model maze;
	private KeyObserver (Model m) { maze = m; }
	public static KeyObserver create (Model m) { 
	    return new KeyObserver(m); 
	}
	public void notify (Character c) {
	    if (c.charValue()=='i')
		maze.performForward();
	    else if (c.charValue()=='k')
		maze.performBack();
	    else if (c.charValue()=='j')
		maze.performLeft();
	    else if (c.charValue()=='l')
		maze.performRight();
	    else if (c.charValue()=='q')
		System.exit(0);
	}
    }

    public void run () { 
	if (maze.isNone())
	    throw new Error("GUIController not initialized with model");
	KeyObserver ko = KeyObserver.create(maze.valOf());
	GUI.registerKeyObserver(ko);
    }

}
	
