
/*
 * Some rather clunky code to get a simple window going that can 
 * be used to draw lines, and to get key presses
 *
 * The GUI view uses it to draw a pictorial representation of the maze
 * and the GUI controller uses it to get key press inputs to control
 * the player
 *
 * This is probably not the best way to use the GUI features of Java...
 *
 */

import java.awt.Canvas; 
import java.awt.Graphics; 
import java.awt.*; 
import java.awt.event.*; 
import java.util.*;

public class GUI {

    private static class Quadtuple {
	public int x1;
	public int y1;
	public int x2;
	public int y2;
	public Quadtuple (int xx1, int yy1, int xx2, int yy2) {
	    x1=xx1; y1=yy1; x2=xx2; y2=yy2;
	}
    }	
    
    private static class CanvasRegion extends Canvas { 
	public LinkedList<Quadtuple> lines = new LinkedList<Quadtuple>();
	public int size = 500;
	public CanvasRegion() {  
	    setSize(size, size); 
	} 
	public void paint(Graphics g) { 
	    for (Quadtuple q:lines) {
		g.drawLine(q.x1,q.y1,q.x2,q.y2);
	    }
	} 
    } 
    
    private static class ClickyMouseAdapter extends MouseAdapter {
	private CanvasFrame parentFrame;
	public ClickyMouseAdapter (CanvasFrame g) {
	    super();
	    parentFrame = g;
	}
	
	public void mouseClicked (MouseEvent e) {
	    parentFrame.clickEvent();
	}
	
    }


    private static class PressKeyAdapter extends KeyAdapter {
	private CanvasFrame parentFrame;
	public PressKeyAdapter (CanvasFrame g) {
	    super();
	    parentFrame = g;
	}
	
	public void keyTyped (KeyEvent e) {
	    parentFrame.keyEvent(e.getKeyChar());
	}
    }
    
    private static class CanvasFrame extends Frame { 
	private CanvasRegion region;
	private boolean click;
	
	public void clickEvent () {
	    this.click = true;
	}

	public void keyEvent(char c) {
	    if (keyObserver != null) 
		keyObserver.notify(c);
	}
	    
	
	public void drawLine (int x1, int y1, int x2, int y2) {
	    this.region.lines.addFirst(new Quadtuple(x1,region.size-y1,
						     x2,region.size-y2));
	}
	
	public void clear () {
	    this.region.lines = new LinkedList<Quadtuple>();
	    this.region.repaint();
	}
	
	public void update () {
	    this.region.repaint();
	}
	
	public void waitForClick () {
	    this.click = false;
	    while (!(this.click)) {
		try {
		    Thread.sleep(500);
		} catch (InterruptedException e) {}
	    }
	}
	
	public CanvasFrame () { 
	    super("Maze"); 
	    region = new CanvasRegion(); 
	    setSize(region.size+30, region.size+30); 
	    add(region); 
	    addWindowListener(new WindowAdapter() { 
		    public void windowClosing(WindowEvent e) { 
			setVisible(false); dispose(); 
			System.exit(0); 
		    } 
		}); 
	    region.addMouseListener(new ClickyMouseAdapter(this));
	    region.addKeyListener(new PressKeyAdapter(this));
	} 
    }
    
    private static CanvasFrame canvasFrame = null;

    private static Observer<Character> keyObserver = null;

    public static void registerKeyObserver (Observer<Character> ko) {
	if (keyObserver == null)
	    keyObserver = ko;
    }

    public static void initialize () {
	if (canvasFrame == null) {
	    canvasFrame = new CanvasFrame();
	    canvasFrame.setVisible(true); 
	}
    }
    
    public static void drawLine (int x1, int y1, int x2, int y2) {
	if (canvasFrame == null) {
	    throw new Error ("GUI not initialized");
	}
	canvasFrame.drawLine(x1,y1,x2,y2);
    }

    public static void clear () {
	if (canvasFrame == null) {
	    throw new Error ("GUI not initialized");
	}
	canvasFrame.clear();
    }

    public static void redraw () {
	if (canvasFrame == null) {
	    throw new Error ("GUI not initialized");
	}
	canvasFrame.update();
    }
    
}