
public class DualView implements View {
    
    private View view1;
    private View view2;

    protected DualView (View v1, View v2) {
	view1 = v1;
	view2 = v2;
    }

    public static DualView create (View v1, View v2) {
	return new DualView(v1,v2);
    }

    public void attachToModel (Model m) {
	view1.attachToModel(m);
	view2.attachToModel(m);
    }

    public void update (Visible vis) {
	view1.update(vis);
	view2.update(vis);
    }

    public void win () {
	view1.win();
	view2.win();
    }

}
