
/*
 * A nice way to represent the four cardinal directions
 *
 * I'm using enums, which you should read about in the Java
 * tutorials
 * 
 * Enums are used to represent values with more meaningful names than 
 * 1,2,3,....
 *
 * Moreover, enums allow you to define methods to act on enums
 *
 * Here, we can ask for the direction left of a particular direction,
 * or right of a particular direction, or opposite a particular 
 * direction
 *
 */

public enum Direction { 

    NORTH, EAST, SOUTH, WEST;

    public Direction left () {
	switch(this) {
	case NORTH: 
	    return WEST;
	case EAST:
	    return NORTH;
	case SOUTH:
	    return EAST;
	case WEST:
	    return SOUTH;
	}
	throw new Error("Unknown direction: " + this);
    }
    
    public Direction right () {
	switch(this) {
	case NORTH: 
	    return EAST;
	case EAST:
	    return SOUTH;
	case SOUTH:
	    return WEST;
	case WEST:
	    return NORTH;
	}
	throw new Error("Unknown direction: " + this);
    }

    public Direction opposite () {
	switch(this) {
	case NORTH: return SOUTH;
	case EAST: return WEST;
	case SOUTH: return NORTH;
	case WEST: return EAST;
	}
	throw new Error("Unknown direction: " + this);
    }

}
