
import java.util.Iterator;
import java.lang.Iterable;

public abstract class Tree<A> implements Iterable<A> {

    public static <A> Tree<A> empty () {
	return new EmptyTree<A>();
    }

    public static <A> Tree<A> node (A v, Tree<A> l, Tree<A> r) {
	return new NodeTree<A>(v,l,r);
    }

    public abstract boolean isEmpty ();
    public abstract A root ();
    public abstract Tree<A> left ();
    public abstract Tree<A> right ();
    public abstract String toString ();

    // equals, hashCode -- complete yourself

    public abstract FuncIterator<A> getFuncIterator ();

    public Iterator<A> iterator () {
	return IteratorAdapter.create(this.getFuncIterator());
    }

}


class EmptyTree<A> extends Tree<A> {

    public EmptyTree () {}

    public boolean isEmpty () {
	return true;
    }

    public A root () {
	throw new RuntimeException("EmptyTree.root()");
    }

    public Tree<A> left () {
	throw new RuntimeException("EmptyTree.left()");
    }

    public Tree<A> right () {
	throw new RuntimeException("EmptyTree.right()");
    }

    public String toString () {
	return "";
    }

    public FuncIterator<A> getFuncIterator () {
	return new EmptyTFuncIterator<A>();
    }
}


class EmptyTFuncIterator<A> implements FuncIterator<A> {

    public EmptyTFuncIterator () {}

    public boolean hasElement () { 
	return false;
    }

    public A current () {
	throw new java.util.NoSuchElementException("EmptyTFuncIterator.current()");
    }

    public FuncIterator<A> advance () {
	throw new java.util.NoSuchElementException("EmptyTFuncIterator.advance()");
    }
}


class NodeTree<A> extends Tree<A> {

    private A root;
    private Tree<A> left;
    private Tree<A> right;

    public NodeTree (A v, Tree<A> l, Tree<A> r) {
	this.root = v;
	this.left = l;
	this.right = r;
    }

    public boolean isEmpty () {
	return false;
    }

    public A root () {
	return this.root;
    }

    public Tree<A> left () {
	return this.left;
    }

    public Tree<A> right () {
	return this.right;
    }

    public String toString () {
	return "[" + this.left() + "] " + this.root() + 
	    " [" + this.right() + "]";
    }


    public FuncIterator<A> getFuncIterator() {
	List<FuncIterator<A>> e = List.empty();
	List<FuncIterator<A>> remainder = 
	    List.cons(this.right().getFuncIterator(),e);
	return new NodeFuncIterator<A>(this.root(),
				       this.left().getFuncIterator(), 
				       remainder);
    }
}


class NodeFuncIterator<A> implements FuncIterator<A> {

    private A currentElement;
    private FuncIterator<A> currentIterator;
    private List<FuncIterator<A>> remainder;

    public NodeFuncIterator (A v, FuncIterator<A> n, List<FuncIterator<A>> r) {
	this.currentElement = v;
	this.currentIterator = n;
	this.remainder = r;
    }

    public boolean hasElement () {
	return true;
    }

    public A current () {
	return this.currentElement;
    }
    
    public FuncIterator<A> advance () {
	// element left in current iterator
	if (this.currentIterator.hasElement())
	    return new NodeFuncIterator<A>(this.currentIterator.current(),
					   this.currentIterator.advance(),
					   this.remainder);
	// no element in current iterator -- any iterators remaining?
	if (this.remainder.isEmpty())
	    return new EmptyTFuncIterator<A>();
	// find next nonempty iterator
	FuncIterator<A> nextIter = this.remainder.first();
	List<FuncIterator<A>> nextRemainder = this.remainder.rest();
	while (!(nextIter.hasElement())) {
	    if (nextRemainder.isEmpty())
		return new EmptyTFuncIterator<A>();
	    nextIter = nextRemainder.first();
	    nextRemainder = nextRemainder.rest();
	}
	return new NodeFuncIterator<A>(nextIter.current(),
				       nextIter.advance(),
				       nextRemainder);
    }
}
