
public abstract class Option<A> {

    public static <A> Option<A> none () {
	return new OptionNone<A>();
    }

    public static <A> Option<A> some (A val) {
	return new OptionSome<A>(val);
    }

    public abstract boolean isNone ();

    public abstract A valOf ();

    public abstract String toString ();
}



class OptionNone<A> extends Option<A> {

    public OptionNone () {}

    public boolean isNone () {
	return true;
    }

    public A valOf () {
	throw new Error ("taking value of a none option");
    }

    public String toString () {
	return "None";
    }
}


class OptionSome<A> extends Option<A> {

    private A value;

    public OptionSome (A v) {
	value = v;
    }

    public boolean isNone () {
	return false;
    }

    public A valOf () {
	return this.value;
    }

    public String toString () {
	return "Some("+this.value.toString()+")";
    }
}
