import java.util.Iterator;

public class Main {

    public static <A> void elements (FuncIterator<A> fIter) {
	FuncIterator<A> it = fIter;
	while (it.hasElement()) {
	    System.out.println(" Element = " + it.current());
	    it = it.advance();
	}
    }

    public static void main (String[] argv) {

	List<String> el = List.empty();
	List<String> l = List.cons("goodbye",List.cons("cruel",List.cons("world",el)));
	System.out.println("l = " + l);

	System.out.println("--------------------------------------------------");
	System.out.println("Loop using functional iterator:");
	FuncIterator<String> it = l.getFuncIterator();
	elements(it);
	System.out.println("Testing immutability:");
	System.out.println(" it.current() = " + it.current());
	System.out.println(" it.current() = " + it.current());

	System.out.println("--------------------------------------------------");
	System.out.println("Loop using Java iterator:");
	for (String s : l) 
	    System.out.println(" Element = " + s);
	System.out.println("Testing mutability:");
	Iterator<String> it3 = l.iterator();
	System.out.println(" it3.next() = " + it3.next());
	System.out.println(" it3.next() = " + it3.next());

	System.out.println("--------------------------------------------------");
	System.out.println("Loop using (converted) functional iterator:");
        Iterator<String> it4 = l.iterator();
	FuncIterator<String> it5 = FuncIteratorAdapter.create(it4);
	elements(it5);
	System.out.println("Testing immutability:");
	System.out.println(" it5.current() = " + it5.current());
	System.out.println(" it5.current() = " + it5.current());

        System.out.println("--------------------------------------------------");
        System.out.println("Messing with iteration:");
        Iterator<String> it6 = l.iterator();
	FuncIterator<String> it7 = FuncIteratorAdapter.create(it6);
	System.out.println(" it7.current() = " + it7.current());
        System.out.println("Advancing underlying iterator -- " + it6.next());
	System.out.println(" it7.advance().current() = " + it7.advance().current());
        
                          
        System.out.println("--------------------------------------------------");
	System.out.println("Testing immutability:");
	System.out.println(" it5.current() = " + it5.current());
	System.out.println(" it5.current() = " + it5.current());
	
	System.out.println("--------------------------------------------------");
	Tree<Integer> et = Tree.empty();
	Tree<Integer> t66 = Tree.node(66,et,et);
	Tree<Integer> t87 = Tree.node(87,et,et);
	Tree<Integer> t = Tree.node(99,t66,t87);
	System.out.println("t = " + t);

	System.out.println("--------------------------------------------------");
	System.out.println("Loop using functional iterator:");
	FuncIterator<Integer> itt = t.getFuncIterator();
	elements(itt);

	System.out.println("--------------------------------------------------");
	System.out.println("Loop using Java iterator:");
	for (Integer i : t) 
	    System.out.println(" Element = " + i);
	
    }

}