(include-book "isa")
(include-book "ma")

#|

Below is the simple motivational example from the paper :

Inst 
   0  add  rb ra ra 
   1  add  ra rb ra

The function ex-imem returns the contents of the instruction
memory corresponding to the above instructions.  Just as I do in
the paper, I then run the ISA machine for two steps in the same
initial state as in the paper and I also run the MA machine for
five steps.

|#

(defun ex-imem ()
  (seq nil
       0 (inst 'add 2 1 1)
       1 (inst 'add 1 2 1)))

(isa-run (isa-state 0 (seq nil 1 1 2 1) (ex-imem) nil) 0)
(isa-run (isa-state 0 (seq nil 1 1 2 1) (ex-imem) nil) 1)
(isa-run (isa-state 0 (seq nil 1 1 2 1) (ex-imem) nil) 2)

(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 0)
(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 1)
(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 2)
(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 3)
(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 4)
(ma-run (ma-state 0 (seq nil 1 1 2 1) (ex-imem) nil nil nil) 5)


#|

Below is the example of a program to multiply (from the paper).
The paper describes the example in detail, so read it.

|#

(defun mul-dmem (x y)
  (seq nil 0 0 1 1 2 x 3 y 4 4 6 6))

(mul-dmem 3 4)

(defun inst (op rc ra rb)
  (seq nil :opcode op :rc rc :ra ra :rb rb))

(defun mul-imem ()
 (seq nil
      0 (inst 'load 0 1 nil)
      1 (inst 'load 1 2 nil)
      2 (inst 'load 2 3 nil)
      3 (inst 'load 3 0 nil)
      4 (inst 'load 4 4 nil)
      5 (inst 'load 6 6 nil)
      6 (inst 'bez nil 1 4)
      7 (inst 'sub 1 1 0)
      8 (inst 'add 3 3 2)
      9 (inst 'jump nil 6 nil)))

(mul-imem)

(isa-run (isa-state 0 nil (mul-imem) (mul-dmem 3 4)) 19)
(ma-run (ma-state 0 nil (mul-imem) (mul-dmem 3 4) nil nil) 30)

; Here is an experiment to test how long it takes to run isa and
; ma for 1,000 steps.
(isa-run (isa-state 0 nil (mul-imem) (mul-dmem 110 110)) 1000)
(ma-run (ma-state 0 nil (mul-imem) (mul-dmem 110 110) nil nil) 1000)

; Note that if we compile the functions, execution is faster.
(comp t)
(isa-run (isa-state 0 nil (mul-imem) (mul-dmem 110 110)) 1000)
(ma-run (ma-state 0 nil (mul-imem) (mul-dmem 110 110) nil nil) 1000)
