(in-package "ACL2")
(set-case-split-limitations 'nil)

(include-book "records")
(include-book "seq")
(include-book "meta")
(include-book "det-encap-wfbisim")
(include-book "isa")
(include-book "ma")

(defun committed-pc (l1 l2 pc)
  (cond ((g :validp l2)
         (g :pch l2))
        ((g :validp l1)
         (g :pch l1))
        (t pc)))

(defun committed-MA (MA)
  (let* ((pc       (g :pc MA))
	 (latch1   (g :latch1 MA))
	 (latch2   (g :latch2 MA)))
    (seq-ma nil :pc     (committed-pc latch1 latch2 pc)
	        :regs   (g :regs MA)
	        :dmem   (g :dmem MA)
	        :imem   (g :imem MA)
                :latch1 (seq-l1 nil)
		:latch2 (seq-l2 nil))))

(defun equiv-l1 (la lb)
  (let ((laop (g :op la))
        (lbop (g :op lb)))
  (and (equal laop lbop)
       (equal (g :pch la) (g :pch lb))
       (implies (in laop '(add sub mul load loadi store bez jump))
                (equal (g :ra la) (g :ra lb)))
       (implies (in laop '(add sub mul store bez))
                (equal (g :rb la) (g :rb lb)))
       (implies (in laop '(add sub mul load loadi))
                (equal (g :rc la) (g :rc lb))))))

(defun equiv-l2 (la lb)
  (let ((laop (g :op la))
        (lbop (g :op lb)))
  (and (equal laop lbop)
       (equal (g :pch la) (g :pch lb))
       (implies (in laop '(add sub mul load loadi store bez jump))
                (equal (g :ra-val la) (g :ra-val lb)))
       (implies (in laop '(add sub mul store bez))
                (equal (g :rb-val la) (g :rb-val lb)))
       (implies (in laop '(add sub mul load loadi))
                (equal (g :rc la) (g :rc lb))))))

(defun equiv-Ma (ma1 ma2)
  (and (equal (g :pc ma1) (g :pc ma2))
       (equal (g :regs ma1) (g :regs ma2))
       (equal (g :dmem ma1) (g :dmem ma2))
       (equal (g :imem ma1) (g :imem ma2))
       (equal (g :validp (g :latch1 MA1)) 
              (g :validp (g :latch1 MA2)))
       (equal (g :validp (g :latch2 MA1)) 
              (g :validp (g :latch2 MA2)))
       (implies (g :validp (g :latch1 MA1))
                (equiv-l1 (g :latch1 ma1) (g :latch1 ma2)))
       (implies (g :validp (g :latch2 MA1))
                (equiv-l2 (g :latch2 ma1) (g :latch2 ma2)))))

(defun good-MA (ma)
  (and (integerp (g :pc MA))
       (let* ((latch1 (g :latch1 MA))
	      (latch2 (g :latch2 MA))
	      (nma (committed-ma ma)))
	 (cond ((g :validp latch2)
		(equiv-ma (ma-step (ma-step nma)) ma))
	       ((g :validp latch1)
		(equiv-ma (ma-step nma) ma))
	       (t t)))))

(defun MA-to-ISA (MA)
  (let ((MA (committed-MA MA)))
    (seq-isa nil :pc   (g :pc MA)
	         :regs (g :regs MA)
		 :dmem (g :dmem MA)
		 :imem (g :imem MA))))

(defun MA-rank (MA)
  (let ((latch1 (g :latch1 MA))
	(latch2 (g :latch2 MA)))
    (cond ((g :validp latch2)
	   0)
	  ((g :validp latch1)
	   1)
	  (t 2))))

;:trans1
(generate-full-system isa-step isa-p ma-step ma-p 
		      ma-to-isa good-ma ma-rank)

(defthm plus-s-g-
  (implies (and (integerp i)
		(not (equal i 0)))
	   (not (equal (s a (+ i (g a w)) r) w)))
     :hints (("goal" :use ((:instance g-same-s- (r1 w) (v (+ i (g a w)))))
	      :in-theory (disable g-same-s- ))))


; Put in records.lisp since it helped the other proofs.
(defthm s-not-equal
  (implies (not (equal x y))
	   (not (equal (s v x r1)
		       (s v y r2))))
  :hints (("goal" :use ((:instance g-same-s (r r1) (a v) (v x))
			(:instance g-same-s (r r2) (a v) (v y)))
	   :in-theory (disable g-same-s ))))

(in-theory (disable (:executable-counterpart s)))

;:trans1
(prove-web isa-step isa-p ma-step ma-p ma-to-isa ma-rank)

#|


This proof fails.  Consider the following code snippet:

add 1 2 3
jump 4

The add & jump will complete at the same time!  So, I have to
either fix my refinement map to account for this or I have to use
skipping.  Skipping seems preferable.

|#

#|

Useful for debugging

(defun disjoint2 (x l)
  (if (endp l)
      t
    (and (not (equal x (car l)))
         (disjoint2 x (cdr l)))))

(defun disjoint (l)
  (if (endp l)
      t
    (and (disjoint2 (car l) (cdr l))
         (disjoint (cdr l)))))


(disjoint '(1 2 3 4))

(skip-proofs
(progn 
(defthm simp-rec7
 (implies
  (disjoint (list f1 f2 f3 f4 f5 f6 f7))
  (equal 
   (equal (s f1 v1 (s f2 v2 (s f3 v3 (s f4 v4 (s f5 v5 (s f6 v6 (s f7 v7 nil)))))))
          (s f1 w1 (s f2 w2 (s f3 w3 (s f4 w4 (s f5 w5 (s f6 w6 (s f7 w7 nil))))))))
   (and (equal v1 w1)
        (equal v2 w2)
        (equal v3 w3)
        (equal v4 w4)
        (equal v5 w5)
        (equal v6 w6)
        (equal v7 w7))))
 :otf-flg t)

(defthm simp-rec6
 (implies
  (disjoint (list f1 f2 f3 f4 f5 f6))
  (equal 
   (equal (s f1 v1 (s f2 v2 (s f3 v3 (s f4 v4 (s f5 v5 (s f6 v6 nil))))))
          (s f1 w1 (s f2 w2 (s f3 w3 (s f4 w4 (s f5 w5 (s f6 w6 nil)))))))
   (and (equal v1 w1)
        (equal v2 w2)
        (equal v3 w3)
        (equal v4 w4)
        (equal v5 w5)
        (equal v6 w6))))
 :otf-flg t)

(defthm simp-rec5
 (implies
  (disjoint (list f1 f2 f3 f4 f5))
  (equal 
   (equal (s f1 v1 (s f2 v2 (s f3 v3 (s f4 v4 (s f5 v5 nil)))))
          (s f1 w1 (s f2 w2 (s f3 w3 (s f4 w4 (s f5 w5 nil))))))
   (and (equal v1 w1)
        (equal v2 w2)
        (equal v3 w3)
        (equal v4 w4)
        (equal v5 w5))))
 :otf-flg t)))

|#

;:trans1

(wrap-it-up isa-step isa-p ma-step ma-p good-ma ma-to-isa ma-rank)
