The structure of a file that uses the web macros for showing the
equivalence of an abstact and concrete version of a determenistic
system is:

include books
(include-book "macro")

Definitions of abs-step, abs-p, con-step, con-p, WF-rel, and con-rank.

; Abs-step is the function that steps the abstract system for one
; step.  Abs-p is the predicate that recognizes abstract states.
; Con-step is the function that steps the concrete system for one
; step.  Con-p is the predicate that recognizes concrete states.
; Con-rank is the rank of a concrete state.  Note that I am assuming
; that the step of abstract and concrete states depends only on the
; state.  There may be situations in which this is not the case.  If
; so, the macros will have to be altered somewhat.  Also, I am
; assuming that the rank of abstract states is 0.  This may also not
; be the case in general.  R, B, rank, and take-appropriate-step
; should be undefined.

(generate-full-system abs-step abs-p con-step con-p con-to-abs good-con con-rank)

auxiliary theorems.

(prove-web abs-step abs-p con-step con-p con-rank)

(wrap-it-up abs-step abs-p con-step con-p 
	    good-con con-to-abs con-rank)
