package com.moteiv.demos.spram;
/**
 * This class is automatically generated by mig. DO NOT EDIT THIS FILE.
 * This class implements a Java interface to the 'SpramDataMsg'
 * message type.
 */

public class SpramDataMsg extends net.tinyos.message.Message {

    /** The default size of this message type in bytes. */
    public static final int DEFAULT_MESSAGE_SIZE = 10;

    /** The Active Message type associated with this message. */
    public static final int AM_TYPE = 33;

    /** Create a new SpramDataMsg of size 10. */
    public SpramDataMsg() {
        super(DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /** Create a new SpramDataMsg of the given data_length. */
    public SpramDataMsg(int data_length) {
        super(data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg with the given data_length
     * and base offset.
     */
    public SpramDataMsg(int data_length, int base_offset) {
        super(data_length, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg using the given byte array
     * as backing store.
     */
    public SpramDataMsg(byte[] data) {
        super(data);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg using the given byte array
     * as backing store, with the given base offset.
     */
    public SpramDataMsg(byte[] data, int base_offset) {
        super(data, base_offset);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg using the given byte array
     * as backing store, with the given base offset and data length.
     */
    public SpramDataMsg(byte[] data, int base_offset, int data_length) {
        super(data, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg embedded in the given message
     * at the given base offset.
     */
    public SpramDataMsg(net.tinyos.message.Message msg, int base_offset) {
        super(msg, base_offset, DEFAULT_MESSAGE_SIZE);
        amTypeSet(AM_TYPE);
    }

    /**
     * Create a new SpramDataMsg embedded in the given message
     * at the given base offset and length.
     */
    public SpramDataMsg(net.tinyos.message.Message msg, int base_offset, int data_length) {
        super(msg, base_offset, data_length);
        amTypeSet(AM_TYPE);
    }

    /**
    /* Return a String representation of this message. Includes the
     * message type name and the non-indexed field values.
     */
    public String toString() {
      String s = "Message <SpramDataMsg> \n";
      try {
        s += "  [addrSender=0x"+Long.toHexString(get_addrSender())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [bytesBegin=0x"+Long.toHexString(get_bytesBegin())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [bytesTotal=0x"+Long.toHexString(get_bytesTotal())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [versionToken=0x"+Long.toHexString(get_versionToken())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [version=0x"+Long.toHexString(get_version())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
        s += "  [flags=0x"+Long.toHexString(get_flags())+"]\n";
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      try {
      } catch (ArrayIndexOutOfBoundsException aioobe) { /* Skip field */ }
      return s;
    }

    // Message-type-specific access methods appear below.

    /////////////////////////////////////////////////////////
    // Accessor methods for field: addrSender
    //   Field type: int, signed
    //   Offset (bits): 0
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'addrSender' is signed (true).
     */
    public static boolean isSigned_addrSender() {
        return true;
    }

    /**
     * Return whether the field 'addrSender' is an array (false).
     */
    public static boolean isArray_addrSender() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'addrSender'
     */
    public static int offset_addrSender() {
        return (0 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'addrSender'
     */
    public static int offsetBits_addrSender() {
        return 0;
    }

    /**
     * Return the value (as a int) of the field 'addrSender'
     */
    public int get_addrSender() {
        return (int)getUIntElement(offsetBits_addrSender(), 16);
    }

    /**
     * Set the value of the field 'addrSender'
     */
    public void set_addrSender(int value) {
        setUIntElement(offsetBits_addrSender(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'addrSender'
     */
    public static int size_addrSender() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'addrSender'
     */
    public static int sizeBits_addrSender() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: bytesBegin
    //   Field type: int, signed
    //   Offset (bits): 16
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'bytesBegin' is signed (true).
     */
    public static boolean isSigned_bytesBegin() {
        return true;
    }

    /**
     * Return whether the field 'bytesBegin' is an array (false).
     */
    public static boolean isArray_bytesBegin() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'bytesBegin'
     */
    public static int offset_bytesBegin() {
        return (16 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'bytesBegin'
     */
    public static int offsetBits_bytesBegin() {
        return 16;
    }

    /**
     * Return the value (as a int) of the field 'bytesBegin'
     */
    public int get_bytesBegin() {
        return (int)getUIntElement(offsetBits_bytesBegin(), 16);
    }

    /**
     * Set the value of the field 'bytesBegin'
     */
    public void set_bytesBegin(int value) {
        setUIntElement(offsetBits_bytesBegin(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'bytesBegin'
     */
    public static int size_bytesBegin() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'bytesBegin'
     */
    public static int sizeBits_bytesBegin() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: bytesTotal
    //   Field type: int, signed
    //   Offset (bits): 32
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'bytesTotal' is signed (true).
     */
    public static boolean isSigned_bytesTotal() {
        return true;
    }

    /**
     * Return whether the field 'bytesTotal' is an array (false).
     */
    public static boolean isArray_bytesTotal() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'bytesTotal'
     */
    public static int offset_bytesTotal() {
        return (32 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'bytesTotal'
     */
    public static int offsetBits_bytesTotal() {
        return 32;
    }

    /**
     * Return the value (as a int) of the field 'bytesTotal'
     */
    public int get_bytesTotal() {
        return (int)getUIntElement(offsetBits_bytesTotal(), 16);
    }

    /**
     * Set the value of the field 'bytesTotal'
     */
    public void set_bytesTotal(int value) {
        setUIntElement(offsetBits_bytesTotal(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'bytesTotal'
     */
    public static int size_bytesTotal() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'bytesTotal'
     */
    public static int sizeBits_bytesTotal() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: versionToken
    //   Field type: int, signed
    //   Offset (bits): 48
    //   Size (bits): 16
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'versionToken' is signed (true).
     */
    public static boolean isSigned_versionToken() {
        return true;
    }

    /**
     * Return whether the field 'versionToken' is an array (false).
     */
    public static boolean isArray_versionToken() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'versionToken'
     */
    public static int offset_versionToken() {
        return (48 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'versionToken'
     */
    public static int offsetBits_versionToken() {
        return 48;
    }

    /**
     * Return the value (as a int) of the field 'versionToken'
     */
    public int get_versionToken() {
        return (int)getUIntElement(offsetBits_versionToken(), 16);
    }

    /**
     * Set the value of the field 'versionToken'
     */
    public void set_versionToken(int value) {
        setUIntElement(offsetBits_versionToken(), 16, value);
    }

    /**
     * Return the size, in bytes, of the field 'versionToken'
     */
    public static int size_versionToken() {
        return (16 / 8);
    }

    /**
     * Return the size, in bits, of the field 'versionToken'
     */
    public static int sizeBits_versionToken() {
        return 16;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: version
    //   Field type: short, signed
    //   Offset (bits): 64
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'version' is signed (true).
     */
    public static boolean isSigned_version() {
        return true;
    }

    /**
     * Return whether the field 'version' is an array (false).
     */
    public static boolean isArray_version() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'version'
     */
    public static int offset_version() {
        return (64 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'version'
     */
    public static int offsetBits_version() {
        return 64;
    }

    /**
     * Return the value (as a short) of the field 'version'
     */
    public short get_version() {
        return (short)getUIntElement(offsetBits_version(), 8);
    }

    /**
     * Set the value of the field 'version'
     */
    public void set_version(short value) {
        setUIntElement(offsetBits_version(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'version'
     */
    public static int size_version() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'version'
     */
    public static int sizeBits_version() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: flags
    //   Field type: short, signed
    //   Offset (bits): 72
    //   Size (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'flags' is signed (true).
     */
    public static boolean isSigned_flags() {
        return true;
    }

    /**
     * Return whether the field 'flags' is an array (false).
     */
    public static boolean isArray_flags() {
        return false;
    }

    /**
     * Return the offset (in bytes) of the field 'flags'
     */
    public static int offset_flags() {
        return (72 / 8);
    }

    /**
     * Return the offset (in bits) of the field 'flags'
     */
    public static int offsetBits_flags() {
        return 72;
    }

    /**
     * Return the value (as a short) of the field 'flags'
     */
    public short get_flags() {
        return (short)getUIntElement(offsetBits_flags(), 8);
    }

    /**
     * Set the value of the field 'flags'
     */
    public void set_flags(short value) {
        setUIntElement(offsetBits_flags(), 8, value);
    }

    /**
     * Return the size, in bytes, of the field 'flags'
     */
    public static int size_flags() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of the field 'flags'
     */
    public static int sizeBits_flags() {
        return 8;
    }

    /////////////////////////////////////////////////////////
    // Accessor methods for field: bytes
    //   Field type: byte[], signed
    //   Offset (bits): 80
    //   Size of each element (bits): 8
    /////////////////////////////////////////////////////////

    /**
     * Return whether the field 'bytes' is signed (true).
     */
    public static boolean isSigned_bytes() {
        return true;
    }

    /**
     * Return whether the field 'bytes' is an array (true).
     */
    public static boolean isArray_bytes() {
        return true;
    }

    /**
     * Return the offset (in bytes) of the field 'bytes'
     */
    public static int offset_bytes(int index1) {
        int offset = 80;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return (offset / 8);
    }

    /**
     * Return the offset (in bits) of the field 'bytes'
     */
    public static int offsetBits_bytes(int index1) {
        int offset = 80;
        if (index1 < 0) throw new ArrayIndexOutOfBoundsException();
        offset += 0 + index1 * 8;
        return offset;
    }

    /**
     * Return the entire array 'bytes' as a byte[]
     */
    public byte[] get_bytes() {
        throw new IllegalArgumentException("Cannot get field as array - unknown size");
    }

    /**
     * Set the contents of the array 'bytes' from the given byte[]
     */
    public void set_bytes(byte[] value) {
        for (int index0 = 0; index0 < value.length; index0++) {
            setElement_bytes(index0, value[index0]);
        }
    }

    /**
     * Return an element (as a byte) of the array 'bytes'
     */
    public byte getElement_bytes(int index1) {
        return (byte)getSIntElement(offsetBits_bytes(index1), 8);
    }

    /**
     * Set an element of the array 'bytes'
     */
    public void setElement_bytes(int index1, byte value) {
        setSIntElement(offsetBits_bytes(index1), 8, value);
    }

    /**
     * Return the size, in bytes, of each element of the array 'bytes'
     */
    public static int elementSize_bytes() {
        return (8 / 8);
    }

    /**
     * Return the size, in bits, of each element of the array 'bytes'
     */
    public static int elementSizeBits_bytes() {
        return 8;
    }

    /**
     * Return the number of dimensions in the array 'bytes'
     */
    public static int numDimensions_bytes() {
        return 1;
    }

    /**
     * Return the number of elements in the array 'bytes'
     * for the given dimension.
     */
    public static int numElements_bytes(int dimension) {
      int array_dims[] = { 0,  };
        if (dimension < 0 || dimension >= 1) throw new ArrayIndexOutOfBoundsException();
        if (array_dims[dimension] == 0) throw new IllegalArgumentException("Array dimension "+dimension+" has unknown size");
        return array_dims[dimension];
    }

    /**
     * Fill in the array 'bytes' with a String
     */
    public void setString_bytes(String s) { 
         int len = s.length();
         int i;
         for (i = 0; i < len; i++) {
             setElement_bytes(i, (byte)s.charAt(i));
         }
         setElement_bytes(i, (byte)0); //null terminate
    }

    /**
     * Read the array 'bytes' as a String
     */
    public String getString_bytes() { 
         char carr[] = new char[net.tinyos.message.Message.MAX_CONVERTED_STRING_LENGTH];
         int i;
         for (i = 0; i < carr.length; i++) {
             if ((char)getElement_bytes(i) == (char)0) break;
             carr[i] = (char)getElement_bytes(i);
         }
         return new String(carr,0,i);
    }

}
