/*
 * Copyright (c) 2003, Vanderbilt University
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE VANDERBILT UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE VANDERBILT
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE VANDERBILT UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE VANDERBILT UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package net.tinyos.mcenter;

/**
 *
 * @author  nadand
 */
public class MessageCenterInternalFrame extends javax.swing.JInternalFrame{

    protected MessageCenterInternalFrame frameInstance;
    
    /** Creates a new instance of messageCenterInternalFrame */
    public MessageCenterInternalFrame(String title) {
        frameInstance = this;
        this.title = title;
        MessageCenter.instance().registerChildFrame(this);
        setIconifiable(true);
        setMaximizable(true);
        setClosable(true);
        setResizable(true);
        this.addInternalFrameListener(new javax.swing.event.InternalFrameAdapter(){
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent e){
                MessageCenter.instance().removeChildFrame(frameInstance);
                SerialConnector.instance().removePacketListener(frameInstance);
            }
        });
    }

    
    public MessageCenterInternalFrame() {
        frameInstance = this;
        this.title = "MessageCenterInternalFrame";
        MessageCenter.instance().registerChildFrame(this);
        setIconifiable(true);
        setMaximizable(true);
        setClosable(true);
        setResizable(true);
        this.addInternalFrameListener(new javax.swing.event.InternalFrameAdapter(){
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent e){
                MessageCenter.instance().removeChildFrame(frameInstance);
            }
        });

    }

    
    
}
