/*
 * Copyright (c) 2003, Vanderbilt University
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE VANDERBILT UNIVERSITY BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE VANDERBILT
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE VANDERBILT UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE VANDERBILT UNIVERSITY HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

/**
 * @author Andras Nadas, Miklos Maroti
 * @last modified 12/04/2003
 */

package net.tinyos.mcenter;

import net.tinyos.packet.*;
import java.util.*;

public class BigMSGDisplay extends MessageCenterInternalFrame implements PacketListenerIF{
    
    protected byte activeMessage = 0x5F;
    protected boolean supressId = false;
    protected java.text.SimpleDateFormat timestamp = null;
    
    protected java.io.File saveFile = new java.io.File("standard.out");
    protected java.io.FileOutputStream fileOut;
    protected java.io.PrintWriter out;
    
    private BigMSGDisplay instance = null;
    
    private java.util.prefs.Preferences prefsRoot = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
    private java.util.prefs.Preferences prefs;
    /** Creates new form BigMSGDisplay */
    public BigMSGDisplay() {
        super("Big Message Display");
        instance = this;
        prefs = prefsRoot.node(prefsRoot.absolutePath()+"/BigMSGDisplay");
        activeMessage = (byte)prefs.getInt("ActiveMessage",0x5f);
        initComponents();
        SerialConnector.instance().registerPacketListener(this,activeMessage);
        this.addInternalFrameListener(new javax.swing.event.InternalFrameAdapter(){
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent e){
                SerialConnector.instance().removePacketListener(instance,activeMessage);
                //CenterFrame.instance().removeChildFrame(instance);
            }
        });
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        subPanel = new javax.swing.JPanel();
        stateLabel = new javax.swing.JLabel();
        stateTextField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        timestampCheckBox = new javax.swing.JCheckBox();
        noidCheckBox = new javax.swing.JCheckBox();
        typeLabel = new javax.swing.JLabel();
        typeTextField = new javax.swing.JTextField();
        jSeparator2 = new javax.swing.JSeparator();
        saveCheckBox = new javax.swing.JCheckBox();
        jTextField1 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();

        setTitle("Big Message Display");
        jScrollPane1.setPreferredSize(new java.awt.Dimension(320, 240));
        jScrollPane1.setViewportView(jTextArea1);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        subPanel.setLayout(new java.awt.GridBagLayout());

        stateLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        stateLabel.setText("state");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        subPanel.add(stateLabel, gridBagConstraints);

        stateTextField.setEditable(false);
        stateTextField.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        stateTextField.setText("mote:0/0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        subPanel.add(stateTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        subPanel.add(jSeparator1, gridBagConstraints);

        timestampCheckBox.setText("print timestamp");
        timestampCheckBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                timestampCheckBoxItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        subPanel.add(timestampCheckBox, gridBagConstraints);

        noidCheckBox.setText("noid");
        noidCheckBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                noidCheckBoxItemStateChanged(evt);
            }
        });

        subPanel.add(noidCheckBox, new java.awt.GridBagConstraints());

        typeLabel.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        typeLabel.setText("msg type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        subPanel.add(typeLabel, gridBagConstraints);

        typeTextField.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        typeTextField.setText("0x"+Integer.toString((byte)activeMessage & 0xFF,16).toUpperCase());
        typeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                typeTextFieldActionPerformed(evt);
            }
        });
        typeTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                typeTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 2.0;
        subPanel.add(typeTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        subPanel.add(jSeparator2, gridBagConstraints);

        saveCheckBox.setText("save");
        saveCheckBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                saveCheckBoxItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 4.0;
        subPanel.add(saveCheckBox, gridBagConstraints);

        jTextField1.setEditable(false);
        jTextField1.setText("standard.out");
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 3.0;
        subPanel.add(jTextField1, gridBagConstraints);

        jButton1.setText("..");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        subPanel.add(jButton1, gridBagConstraints);

        getContentPane().add(subPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void typeTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_typeTextFieldFocusLost
        // Add your handling code here:
    }//GEN-LAST:event_typeTextFieldFocusLost
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        javax.swing.JFileChooser chooser = new javax.swing.JFileChooser();
        chooser.setDialogTitle("Choose Directory to save");
        int returnVal = chooser.showSaveDialog(this);
        if(returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
            saveFile = chooser.getSelectedFile();
            jTextField1.setText(saveFile.getName());
        }
        
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        typeTextFieldActionPerformed(null);
    }//GEN-LAST:event_jTextField1ActionPerformed
    
    private void saveCheckBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_saveCheckBoxItemStateChanged
        try{
            if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED) {
                jButton1.setEnabled(false);
                fileOut = new java.io.FileOutputStream(saveFile);
                out = new java.io.PrintWriter(fileOut);
                
            } else if(evt.getStateChange() == java.awt.event.ItemEvent.DESELECTED) {
                jButton1.setEnabled(true);
                fileOut=null;
                out = null;
            }
        }catch(java.io.FileNotFoundException fnfe){
        }
    }//GEN-LAST:event_saveCheckBoxItemStateChanged
    
    private void typeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_typeTextFieldActionPerformed
        try{
            String arg = typeTextField.getText();
            if( !arg.toUpperCase().startsWith("0X") ) {
                typeTextField.setText("0X"+Integer.toHexString(activeMessage));
                arg = typeTextField.getText();
            }
            SerialConnector.instance().removePacketListener(this,activeMessage);
            activeMessage =(byte)Integer.parseInt(arg.substring(2), 16) ;
            
            SerialConnector.instance().registerPacketListener(this,activeMessage);
            prefs.putInt("ActiveMessage",activeMessage);
        }catch(java.lang.NumberFormatException nfe){
            System.err.println("Cannot parse type field: "+nfe.getMessage());
        }

        
    }//GEN-LAST:event_typeTextFieldActionPerformed
    
    private void timestampCheckBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_timestampCheckBoxItemStateChanged
        if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED) {
            timestamp = new java.text.SimpleDateFormat("HH:mm:ss.SSSS");
        } else if(evt.getStateChange() == java.awt.event.ItemEvent.DESELECTED) {
            timestamp = null;
        }
    }//GEN-LAST:event_timestampCheckBoxItemStateChanged
    
    private void noidCheckBoxItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_noidCheckBoxItemStateChanged
        if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED) {
            supressId = true;
        } else if(evt.getStateChange() == java.awt.event.ItemEvent.DESELECTED) {
            supressId = false;
        }
    }//GEN-LAST:event_noidCheckBoxItemStateChanged
    
    static protected class BigMsg {
        int lastSeqNum;
        int nextPosition;
        byte[] packet;
    }
    
    protected HashMap bigMsgs = new HashMap();
    
    static final int PACKET_TYPE_FIELD = 2;
    static final int PACKET_LENGTH_FIELD = 4;
    static final int PACKET_SOURCE = 5;
    static final int PACKET_SEQNUM = 7;
    static final int PACKET_DATA = 8;

    
    // the first 5 bytes are: addr(2), type(1), group(1), length(1)
    public void packetReceived(byte[] packet) {
        if( packet[PACKET_TYPE_FIELD] != activeMessage )
            return;
        
        byte len = packet[PACKET_LENGTH_FIELD];
        int source = getShort(packet[PACKET_SOURCE], packet[PACKET_SOURCE+1]);
        int seqNum = packet[PACKET_SEQNUM] & 0xFF;
        
        // wrong format
        if( len < 4 || PACKET_SOURCE + len > packet.length )
            return;
        len -= 3;	// omit the source and seqnum fields
        
        byte[] data = new byte[len];
        System.arraycopy(packet, PACKET_DATA, data, 0, len);
        
        BigMsg bigMsg;
        if( seqNum == 0 ) {
            bigMsgs.remove(new Integer(source));
            
            bigMsg = new BigMsg();
            bigMsg.lastSeqNum = 0;
            bigMsg.packet = new byte[getShort(data[0], data[1])];
            bigMsg.nextPosition = data.length - 2;
            System.arraycopy(data, 2, bigMsg.packet, 0, bigMsg.nextPosition);
            
            bigMsgs.put(new Integer(source), bigMsg);
        }
        else {
            bigMsg = (BigMsg)bigMsgs.get(new Integer(source));
            
            if( bigMsg == null || seqNum == bigMsg.lastSeqNum ){
                
                return;
            }else if( seqNum != bigMsg.lastSeqNum+1 ){
                
                bigMsgs.remove(new Integer(source));
            }
            bigMsg.lastSeqNum = seqNum;
            System.arraycopy(data, 0, bigMsg.packet, bigMsg.nextPosition, data.length);
            bigMsg.nextPosition += data.length;
        }
        
        stateTextField.setText("mote"+source+":"+ bigMsg.nextPosition +"/" + bigMsg.packet.length );
        //System.out.println("mote"+source+":"+ bigMsg.nextPosition +"/" + bigMsg.packet.length );
        
        if( bigMsg.nextPosition == bigMsg.packet.length ) {
            bigMsgs.remove(new Integer(Integer.toString(source)));
            
            if( timestamp != null ){
                jTextArea1.append(timestamp.format(new java.util.Date()) + ' ');
                if(out != null)
                    out.print(timestamp.format(new java.util.Date()) + ' ');
            }
            if( !supressId ) {
                jTextArea1.append(Integer.toString(source));
                jTextArea1.append(" ");
                if(out != null)
                    out.print(Integer.toString(source)+" ");
            }
            
            for(int i = 0; i < bigMsg.packet.length; ++i ) {
                jTextArea1.append(Integer.toString(bigMsg.packet[i] & 0xFF));
                jTextArea1.append(" ");
                if(out != null)
                    out.print(Integer.toString(bigMsg.packet[i] & 0xFF) + " ");
            }
            
            jTextArea1.append("\n");
            this.jTextArea1.setCaretPosition(this.jTextArea1.getDocument().getLength());
            if(out != null)
                    out.println("");
			if(out != null)
					out.flush();
					
        }
    }
    
    protected int getShort(byte a, byte b) {
        return (a & 0x00FF) + ((b << 8) & 0xFF00);
    }
    
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JCheckBox noidCheckBox;
    private javax.swing.JCheckBox saveCheckBox;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JTextField stateTextField;
    private javax.swing.JPanel subPanel;
    private javax.swing.JCheckBox timestampCheckBox;
    private javax.swing.JLabel typeLabel;
    private javax.swing.JTextField typeTextField;
    // End of variables declaration//GEN-END:variables
    
}
