#!/bin/sh
prefix=/usr/autotool/devel
bindir=${prefix}/bin
sysbindir=/usr/bin
NAME=automake-devel-1.9.2
TESTRUN=/bin/false

do_family() {
  (echo cd $sysbindir
   $TESTRUN || cd $sysbindir

   echo rm -f automake-$1 
   $TESTRUN || rm -f automake-$1

   echo rm -f aclocal-$1
   $TESTRUN || rm -f aclocal-$1
  )
}

do_core() {
  (echo cd $bindir
   $TESTRUN || cd $bindir

   echo rm -f automake
   $TESTRUN || rm -f automake

   echo rm -f aclocal
   $TESTRUN || rm -f aclocal

   # NOT removing dirlist!  We can survive missing
   # /usr/autotool/devel/bin/automake, but we NEED
   # dirlist or the other versions will break.
  )
}

findver() {
  echo $1 | sed -n -e 's/^[^0-9]*\-\([0-9\.\-]*\)$/\1/p'
}
findfamily() {
  echo $1 | sed -n -e 's/^[^0-9]*\-\([0-9]*\)\.\([0-9]*\)\.\([0-9]*\)$/\1.\2/p'
}
nover() {
  echo $1 | sed -n -e 's/^\([^0-9]*\)-[0-9\.\-]*$/\1/p'
}


myVERSION=`findver $NAME`
myPACKAGE=`nover $NAME`
myFAMILY=`findfamily $NAME`

do_family $myFAMILY
do_core   $myFAMILY

