#ifndef _H_hardware_h
#define _H_hardware_h

#include "msp430hardware.h"
#include "MSP430ADC12.h"

#include "CC2420Const.h"
#include "AM.h"

#include "Timer2.h"
#include "Resource.h"

TOSH_ASSIGN_PIN(ROSC, 5, 2);
// LEDs
TOSH_ASSIGN_PIN(RED_LED, 5, 4);
TOSH_ASSIGN_PIN(GREEN_LED, 5, 5);
TOSH_ASSIGN_PIN(YELLOW_LED, 5, 6);

// CC2420 RADIO #defines
TOSH_ASSIGN_PIN(RADIO_CSN, 4, 2);
TOSH_ASSIGN_PIN(RADIO_VREF, 4, 5);
TOSH_ASSIGN_PIN(RADIO_RESET, 4, 6);
TOSH_ASSIGN_PIN(RADIO_FIFOP, 1, 0);
TOSH_ASSIGN_PIN(RADIO_SFD, 4, 1);
TOSH_ASSIGN_PIN(RADIO_GIO0, 1, 3);
TOSH_ASSIGN_PIN(RADIO_FIFO, 1, 3);
TOSH_ASSIGN_PIN(RADIO_GIO1, 1, 4);
TOSH_ASSIGN_PIN(RADIO_CCA, 1, 4);

TOSH_ASSIGN_PIN(CC_FIFOP, 1, 0);
TOSH_ASSIGN_PIN(CC_FIFO, 1, 3);
TOSH_ASSIGN_PIN(CC_SFD, 4, 1);
TOSH_ASSIGN_PIN(CC_VREN, 4, 5);
TOSH_ASSIGN_PIN(CC_RSTN, 4, 6);

// UART pins
TOSH_ASSIGN_PIN(SOMI0, 3, 2);
TOSH_ASSIGN_PIN(SIMO0, 3, 1);
TOSH_ASSIGN_PIN(UCLK0, 3, 3);
TOSH_ASSIGN_PIN(STE0, 3, 0);
TOSH_ASSIGN_PIN(UTXD0, 3, 4);
TOSH_ASSIGN_PIN(URXD0, 3, 5);
TOSH_ASSIGN_PIN(UTXD1, 3, 6);
TOSH_ASSIGN_PIN(URXD1, 3, 7);
TOSH_ASSIGN_PIN(UCLK1, 5, 3);
TOSH_ASSIGN_PIN(SOMI1, 5, 2);
TOSH_ASSIGN_PIN(SIMO1, 5, 1);
TOSH_ASSIGN_PIN(STE1, 5, 0);

// ADC
TOSH_ASSIGN_PIN(ADC0, 6, 0);
TOSH_ASSIGN_PIN(ADC1, 6, 1);
TOSH_ASSIGN_PIN(ADC2, 6, 2);
TOSH_ASSIGN_PIN(ADC3, 6, 3);
TOSH_ASSIGN_PIN(ADC4, 6, 4);
TOSH_ASSIGN_PIN(ADC5, 6, 5);
TOSH_ASSIGN_PIN(ADC6, 6, 6);
TOSH_ASSIGN_PIN(ADC7, 6, 7);

// HUMIDITY
TOSH_ASSIGN_PIN(HUM_SDA, 1, 5);
TOSH_ASSIGN_PIN(HUM_SCL, 1, 6);
TOSH_ASSIGN_PIN(HUM_PWR, 1, 7);

// GIO pins
TOSH_ASSIGN_PIN(GIO0, 2, 0);
TOSH_ASSIGN_PIN(GIO1, 2, 1);
TOSH_ASSIGN_PIN(GIO2, 2, 3);
TOSH_ASSIGN_PIN(GIO3, 2, 6);

// 1-Wire
TOSH_ASSIGN_PIN(ONEWIRE, 2, 4);

// FLASH
TOSH_ASSIGN_PIN(FLASH_PWR, 4, 3);
TOSH_ASSIGN_PIN(FLASH_CS, 4, 4);
TOSH_ASSIGN_PIN(FLASH_HOLD, 4, 7);

// Detect if the mote is plugged into USB
TOSH_ASSIGN_PIN(USB_DETECT, 1, 2);

// PROGRAMMING PINS (tri-state)
//TOSH_ASSIGN_PIN(TCK, );
TOSH_ASSIGN_PIN(PROG_RX, 1, 1);
TOSH_ASSIGN_PIN(PROG_TX, 2, 2);

// send a bit via bit-banging to the flash
void TOSH_FLASH_M25P_DP_bit(bool set) {
  if (set)
    TOSH_SET_SIMO0_PIN();
  else
    TOSH_CLR_SIMO0_PIN();
  TOSH_SET_UCLK0_PIN();
  TOSH_CLR_UCLK0_PIN();
}

// put the flash into deep sleep mode
// important to do this by default
void TOSH_FLASH_M25P_DP() {
  //  SIMO0, UCLK0
  TOSH_MAKE_SIMO0_OUTPUT();
  TOSH_MAKE_UCLK0_OUTPUT();
  TOSH_MAKE_FLASH_HOLD_OUTPUT();
  TOSH_MAKE_FLASH_CS_OUTPUT();
  TOSH_SET_FLASH_HOLD_PIN();
  TOSH_SET_FLASH_CS_PIN();

  TOSH_wait();

  // initiate sequence;
  TOSH_CLR_FLASH_CS_PIN();
  TOSH_CLR_UCLK0_PIN();
  
  TOSH_FLASH_M25P_DP_bit(TRUE);   // 0
  TOSH_FLASH_M25P_DP_bit(FALSE);  // 1
  TOSH_FLASH_M25P_DP_bit(TRUE);   // 2
  TOSH_FLASH_M25P_DP_bit(TRUE);   // 3
  TOSH_FLASH_M25P_DP_bit(TRUE);   // 4
  TOSH_FLASH_M25P_DP_bit(FALSE);  // 5
  TOSH_FLASH_M25P_DP_bit(FALSE);  // 6
  TOSH_FLASH_M25P_DP_bit(TRUE);   // 7

  //MSP430_INIT_P31 = MSP430_INIT_PIN_DIGITAL_OUT_1, //SIMO0
  //MSP430_INIT_P33 = MSP430_INIT_PIN_DIGITAL_OUT_1, //UCLK0
  //MSP430_INIT_P44 = MSP430_INIT_PIN_DIGITAL_OUT_1, //FLASH_CS
  //MSP430_INIT_P47 = MSP430_INIT_PIN_DIGITAL_OUT_1, //FLASH_HOLD
  TOSH_SET_FLASH_HOLD_PIN();
  TOSH_SET_FLASH_CS_PIN();
  TOSH_SET_UCLK0_PIN();
  TOSH_SET_SIMO0_PIN();
}


// == MSP430 pin intialization ==
// * First define bitfields and helper macros for constructing initial state
// definitions of each pin.
// * Next, define enums that fully describe a possible initial pin state (like
// digital output 0).
// * Then, assign an initial state to every pin.
// * Finally, decode the initial pin assignments into MCU instructions, using
// the preprocessor to reduce code size.

enum {
  MSP430_INIT_PIN_SELBIT = 0x04, // false = digital io, true = module function
  MSP430_INIT_PIN_DIRBIT = 0x02, // false = input, true = output
  MSP430_INIT_PIN_OUTBIT = 0x01, // false = output low, true = output high
};
#define MSP430_INIT_PIN_SEL(pin,init) (((init)&MSP430_INIT_PIN_SELBIT?1:0)<<(pin))
#define MSP430_INIT_PIN_DIR(pin,init) (((init)&MSP430_INIT_PIN_DIRBIT?1:0)<<(pin))
#define MSP430_INIT_PIN_OUT(pin,init) (((init)&MSP430_INIT_PIN_OUTBIT?1:0)<<(pin))

enum {
  MSP430_INIT_PIN_DIGITAL_OUT_0 = MSP430_INIT_PIN_DIRBIT,
  MSP430_INIT_PIN_DIGITAL_OUT_1 = MSP430_INIT_PIN_DIRBIT | MSP430_INIT_PIN_OUTBIT,
  MSP430_INIT_PIN_DIGITAL_IN = 0,
  MSP430_INIT_PIN_MODULE_IN = MSP430_INIT_PIN_SELBIT,
  MSP430_INIT_PIN_MODULE_OUT = MSP430_INIT_PIN_SELBIT | MSP430_INIT_PIN_DIRBIT,
};


enum {
  //P1DIR = 0xe0;
  //P1OUT = 0x00;
  // 12  P1.0/TACLK  PKT_INT (FIFOP) digout 0
  // 13  P1.1/TA0/BSLTX  UART1TX digin (driven by P36)
  // 14  P1.2/TA1  P_DVCC  digin
  // 15  P1.3/TA2  RADIO_GIO0 (FIFO) digout 0
  // 16  P1.4/SMCLK  RADIO_GIO1 (CCA)  digout 0
  // 17  P1.5/TA0  HUM_SDA digout 1
  // 18  P1.6/TA1  HUM_SCL digout 0
  // 19  P1.7/TA2  HUM_PWR digout 0
  MSP430_INIT_P10 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P11 = MSP430_INIT_PIN_DIGITAL_IN,
  MSP430_INIT_P12 = MSP430_INIT_PIN_DIGITAL_IN,
  MSP430_INIT_P13 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P14 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P15 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P16 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P17 = MSP430_INIT_PIN_DIGITAL_OUT_0,

  //P2DIR = 0x7b;
  //P2OUT = 0x30;
  // 20  P2.0/ACLK GIO0  digout 0
  // 21  P2.1/TAINCLK  GIO1  digout 0
  // 22  P2.2/CAOUT/TA0/BSLRX  UART1RX digin (driven by P37)
  // 23  P2.3/CA0/TA1  GIO2  digout 0
  // 24  P2.4/CA1/TA2  1Wire digout 1
  // 25  P2.5/Rosc x/Vcc (which?)  digout 1
  // 26  P2.6/ADC12CLK/DMAE0 GIO3  digout 0
  // 27  P2.67/TA0 UserINT digin
  MSP430_INIT_P20 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P21 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P22 = MSP430_INIT_PIN_DIGITAL_IN,
  MSP430_INIT_P23 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P24 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P25 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P26 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P27 = MSP430_INIT_PIN_DIGITAL_IN,

  //P3DIR = 0xf1;
  //P3OUT = 0x00;
  // 28  P3.0/STE0 x digout 0
  // 29  P3.1/SIMO0/SDA  RADIO_SI/I2C_SDA  digout 1
  // 30  P3.2/SOMI0  RADIO_SO  digout 1
  // 31  P3.3/UCLK0/SCL  RADIO_SCLK/I2C_SCL  digout 1
  // 32  P3.4/UTXD0  UART0TX digout 0
  // 33  P3.5/URXD0  UART0RX digout 0
  // 34  P3.6/UTXD1  UART1TX digout 0 (drives P11)
  // 35  P3.7/URXD1  UART1RX digout 0 (drives P22)
  MSP430_INIT_P30 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P31 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P32 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P33 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P34 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P35 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P36 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P37 = MSP430_INIT_PIN_DIGITAL_OUT_0,

  //P4DIR = 0xfd;
  //P4OUT = 0xdd;
  // 36  P4.0/TB0  x digout 0
  // 37  P4.1/TB1  RADIO_SFD digout 0
  // 38  P4.2/TB2  RADIO_CS  digout 1
  // 39  P4.3/TB3  x digout 0
  // 40  P4.4/TB4  FLASH_CS  digout 1
  // 41  P4.5/TB5  RADIO_VREF_EN digout 0
  // 42  P4.6/TB6  RADIO_RESET digout 1
  // 43  P4.7/TBCLK  FLASH_HOLD  digout 1
  MSP430_INIT_P40 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P41 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P42 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P43 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P44 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P45 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P46 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P47 = MSP430_INIT_PIN_DIGITAL_OUT_1,

  //P5DIR = 0xff;
  //P5OUT = 0xff;
  // 44  P5.0/STE1 x digout 0
  // 45  P5.1/SIMO1  x digout 0
  // 46  P5.2/SOMI1  x digout 0
  // 47  P5.3/UCLK1  x digout 0
  // 48  P5.4/MCLK LED1  digout 1
  // 49  P5.5/SMCLK  LED2  digout 1
  // 50  P5.6/ACLK LED3  digout 1
  // 51  P5.7/TBoutH/SVSOUT  SVSout  digout 0
  MSP430_INIT_P50 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P51 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P52 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P53 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P54 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P55 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P56 = MSP430_INIT_PIN_DIGITAL_OUT_1,
  MSP430_INIT_P57 = MSP430_INIT_PIN_DIGITAL_OUT_0,

  //P6DIR = 0xff;
  //P6OUT = 0x00;
  // 59  P6.0/A0 ADC0  digout 0
  // 60  P6.1/A1 ADC1  digout 0
  // 61  P6.2/A2 ADC2  digout 0
  //  2  P6.3/A3 ADC3  digout 0
  //  3  P6.4/A4 ADC4  digout 0
  //  4  P6.5/A5 ADC5  digout 0
  //  5  P6.6/A6/DAC0  ADC6/DAC0 digout 0
  //  6  P6.7/A7/DAC1/SVSIN  ADC7/SVSin  digout 0
  MSP430_INIT_P60 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P61 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P62 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P63 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P64 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P65 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P66 = MSP430_INIT_PIN_DIGITAL_OUT_0,
  MSP430_INIT_P67 = MSP430_INIT_PIN_DIGITAL_OUT_0,
};

// need to undef atomic inside header files or nesC ignores the directive
#undef atomic
void TOSH_SET_PIN_DIRECTIONS(void)
{
  // reset all of the ports to be input and using i/o functionality
  atomic
  {

  // Port 1
  P1SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P10) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P11) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P12) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P13) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P14) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P15) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P16) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P17);

  P1DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P10) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P11) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P12) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P13) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P14) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P15) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P16) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P17);

  P1OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P10) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P11) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P12) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P13) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P14) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P15) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P16) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P17);

  // Port 2
  P2SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P20) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P21) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P22) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P23) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P24) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P25) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P26) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P27);

  P2DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P20) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P21) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P22) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P23) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P24) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P25) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P26) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P27);

  P2OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P20) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P21) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P22) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P23) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P24) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P25) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P26) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P27);

  // Port 2
  P3SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P30) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P31) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P32) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P33) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P34) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P35) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P36) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P37);

  P3DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P30) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P31) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P32) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P33) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P34) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P35) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P36) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P37);

  P3OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P30) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P31) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P32) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P33) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P34) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P35) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P36) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P37);

  // Port 4
  P4SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P40) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P41) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P42) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P43) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P44) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P45) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P46) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P47);

  P4DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P40) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P41) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P42) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P43) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P44) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P45) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P46) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P47);

  P4OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P40) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P41) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P42) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P43) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P44) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P45) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P46) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P47);

  // Port 5
  P5SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P50) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P51) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P52) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P53) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P54) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P55) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P56) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P57);

  P5DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P50) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P51) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P52) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P53) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P54) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P55) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P56) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P57);

  P5OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P50) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P51) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P52) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P53) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P54) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P55) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P56) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P57);

  // Port 6
  P6SEL = MSP430_INIT_PIN_SEL(0,MSP430_INIT_P60) |
          MSP430_INIT_PIN_SEL(1,MSP430_INIT_P61) |
          MSP430_INIT_PIN_SEL(2,MSP430_INIT_P62) |
          MSP430_INIT_PIN_SEL(3,MSP430_INIT_P63) |
          MSP430_INIT_PIN_SEL(4,MSP430_INIT_P64) |
          MSP430_INIT_PIN_SEL(5,MSP430_INIT_P65) |
          MSP430_INIT_PIN_SEL(6,MSP430_INIT_P66) |
          MSP430_INIT_PIN_SEL(7,MSP430_INIT_P67);

  P6DIR = MSP430_INIT_PIN_DIR(0,MSP430_INIT_P60) |
          MSP430_INIT_PIN_DIR(1,MSP430_INIT_P61) |
          MSP430_INIT_PIN_DIR(2,MSP430_INIT_P62) |
          MSP430_INIT_PIN_DIR(3,MSP430_INIT_P63) |
          MSP430_INIT_PIN_DIR(4,MSP430_INIT_P64) |
          MSP430_INIT_PIN_DIR(5,MSP430_INIT_P65) |
          MSP430_INIT_PIN_DIR(6,MSP430_INIT_P66) |
          MSP430_INIT_PIN_DIR(7,MSP430_INIT_P67);

  P6OUT = MSP430_INIT_PIN_OUT(0,MSP430_INIT_P60) |
          MSP430_INIT_PIN_OUT(1,MSP430_INIT_P61) |
          MSP430_INIT_PIN_OUT(2,MSP430_INIT_P62) |
          MSP430_INIT_PIN_OUT(3,MSP430_INIT_P63) |
          MSP430_INIT_PIN_OUT(4,MSP430_INIT_P64) |
          MSP430_INIT_PIN_OUT(5,MSP430_INIT_P65) |
          MSP430_INIT_PIN_OUT(6,MSP430_INIT_P66) |
          MSP430_INIT_PIN_OUT(7,MSP430_INIT_P67);

  // Disable all interrupts on P1 and P2
  P1IE = 0;
  P2IE = 0;

  // wait 10ms for the flash to startup
  TOSH_uwait(1024*10);
  // Put the flash in deep sleep state
  TOSH_FLASH_M25P_DP();
  }//atomic
}

#endif // _H_hardware_h

